/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

public class ClientID
implements Serializable {
    private final String clientName;
    private final UUID uuid;

    public ClientID(@Nonnull String clientName) {
        this.clientName = Objects.requireNonNull(clientName, "clientName");
        this.uuid = UUID.randomUUID();
    }

    @Nonnull
    public String getClientName() {
        return this.clientName;
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof ClientID) {
            ClientID otherID = (ClientID)otherObject;
            return this.clientName.equals(otherID.clientName) && this.uuid.equals(otherID.uuid);
        }
        return false;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        return this.clientName + ":" + String.valueOf(this.uuid);
    }
}

