/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.drivers.vehicle;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Triple;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.notification.UserNotification;
import org.opentcs.drivers.vehicle.LoadHandlingDevice;
import org.opentcs.drivers.vehicle.MovementCommand;
import org.opentcs.drivers.vehicle.VehicleCommAdapterEvent;

public class VehicleProcessModel {
    private static final int MAX_NOTIFICATION_COUNT = 100;
    private final Vehicle vehicle;
    private final TCSObjectReference<Vehicle> vehicleReference;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Map<String, String> vehicleProperties = new HashMap<String, String>();
    private final Map<String, String> transportOrderProperties = new HashMap<String, String>();
    private boolean commAdapterEnabled;
    private boolean commAdapterConnected;
    private String vehiclePosition;
    private final Queue<UserNotification> notifications = new LinkedList<UserNotification>();
    private Triple precisePosition;
    private double orientationAngle = Double.NaN;
    private int energyLevel = 100;
    private List<LoadHandlingDevice> loadHandlingDevices = new ArrayList<LoadHandlingDevice>();
    private Vehicle.State state = Vehicle.State.UNKNOWN;
    private int length;

    public VehicleProcessModel(@Nonnull Vehicle attachedVehicle) {
        this.vehicle = Objects.requireNonNull(attachedVehicle, "attachedVehicle");
        this.vehicleReference = this.vehicle.getReference();
        this.length = this.vehicle.getLength();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Nonnull
    public TCSObjectReference<Vehicle> getVehicleReference() {
        return this.vehicleReference;
    }

    @Nonnull
    public String getName() {
        return this.vehicleReference.getName();
    }

    @Nonnull
    public Queue<UserNotification> getNotifications() {
        return this.notifications;
    }

    public void publishUserNotification(@Nonnull UserNotification notification) {
        Objects.requireNonNull(notification, "notification");
        this.notifications.add(notification);
        while (this.notifications.size() > 100) {
            this.notifications.remove();
        }
        this.getPropertyChangeSupport().firePropertyChange(Attribute.USER_NOTIFICATION.name(), null, notification);
    }

    public void publishEvent(@Nonnull VehicleCommAdapterEvent event) {
        Objects.requireNonNull(event, "event");
        this.getPropertyChangeSupport().firePropertyChange(Attribute.COMM_ADAPTER_EVENT.name(), null, event);
    }

    public boolean isCommAdapterEnabled() {
        return this.commAdapterEnabled;
    }

    public void setCommAdapterEnabled(boolean commAdapterEnabled) {
        boolean oldValue = this.commAdapterEnabled;
        this.commAdapterEnabled = commAdapterEnabled;
        this.getPropertyChangeSupport().firePropertyChange(Attribute.COMM_ADAPTER_ENABLED.name(), oldValue, commAdapterEnabled);
    }

    public boolean isCommAdapterConnected() {
        return this.commAdapterConnected;
    }

    public void setCommAdapterConnected(boolean commAdapterConnected) {
        boolean oldValue = this.commAdapterConnected;
        this.commAdapterConnected = commAdapterConnected;
        this.getPropertyChangeSupport().firePropertyChange(Attribute.COMM_ADAPTER_CONNECTED.name(), oldValue, commAdapterConnected);
    }

    @Nullable
    public String getVehiclePosition() {
        return this.vehiclePosition;
    }

    public void setVehiclePosition(@Nullable String position) {
        String oldValue = this.vehiclePosition;
        this.vehiclePosition = position;
        this.getPropertyChangeSupport().firePropertyChange(Attribute.POSITION.name(), oldValue, position);
    }

    @Nullable
    public Triple getVehiclePrecisePosition() {
        return this.precisePosition;
    }

    public void setVehiclePrecisePosition(@Nullable Triple position) {
        Triple oldValue = this.precisePosition;
        this.precisePosition = position;
        this.getPropertyChangeSupport().firePropertyChange(Attribute.PRECISE_POSITION.name(), oldValue, position);
    }

    public double getVehicleOrientationAngle() {
        return this.orientationAngle;
    }

    public void setVehicleOrientationAngle(double angle) {
        double oldValue = this.orientationAngle;
        this.orientationAngle = angle;
        this.getPropertyChangeSupport().firePropertyChange(Attribute.ORIENTATION_ANGLE.name(), oldValue, angle);
    }

    public int getVehicleEnergyLevel() {
        return this.energyLevel;
    }

    public void setVehicleEnergyLevel(int newLevel) {
        int oldValue = this.energyLevel;
        this.energyLevel = newLevel;
        this.getPropertyChangeSupport().firePropertyChange(Attribute.ENERGY_LEVEL.name(), oldValue, newLevel);
    }

    @Nonnull
    public List<LoadHandlingDevice> getVehicleLoadHandlingDevices() {
        return this.loadHandlingDevices;
    }

    public void setVehicleLoadHandlingDevices(@Nonnull List<LoadHandlingDevice> devices) {
        ArrayList<LoadHandlingDevice> devs = new ArrayList<LoadHandlingDevice>(devices);
        List<LoadHandlingDevice> oldValue = this.loadHandlingDevices;
        this.loadHandlingDevices = devs;
        this.getPropertyChangeSupport().firePropertyChange(Attribute.LOAD_HANDLING_DEVICES.name(), oldValue, devs);
    }

    public void setVehicleProperty(@Nonnull String key, @Nullable String value) {
        Objects.requireNonNull(key, "key");
        String oldValue = this.vehicleProperties.get(key);
        if (Objects.equals(value, oldValue)) {
            return;
        }
        this.vehicleProperties.put(key, value);
        this.getPropertyChangeSupport().firePropertyChange(Attribute.VEHICLE_PROPERTY.name(), null, new VehiclePropertyUpdate(key, value));
    }

    @Nonnull
    public Vehicle.State getVehicleState() {
        return this.state;
    }

    public void setVehicleState(@Nonnull Vehicle.State newState) {
        Vehicle.State oldState = this.state;
        this.state = newState;
        this.getPropertyChangeSupport().firePropertyChange(Attribute.STATE.name(), (Object)oldState, (Object)newState);
        if (oldState != Vehicle.State.ERROR && newState == Vehicle.State.ERROR) {
            this.publishUserNotification(new UserNotification(this.getName(), "Vehicle state changed to ERROR", UserNotification.Level.NOTEWORTHY));
        } else if (oldState == Vehicle.State.ERROR && newState != Vehicle.State.ERROR) {
            this.publishUserNotification(new UserNotification(this.getName(), "Vehicle state is no longer ERROR", UserNotification.Level.NOTEWORTHY));
        }
    }

    public int getVehicleLength() {
        return this.length;
    }

    public void setVehicleLength(int length) {
        int oldValue = this.length;
        this.length = length;
        this.getPropertyChangeSupport().firePropertyChange(Attribute.LENGTH.name(), oldValue, length);
    }

    public void setTransportOrderProperty(@Nonnull String key, @Nullable String value) {
        Objects.requireNonNull(key, "key");
        String oldValue = this.transportOrderProperties.get(key);
        if (Objects.equals(value, oldValue)) {
            return;
        }
        this.transportOrderProperties.put(key, value);
        this.getPropertyChangeSupport().firePropertyChange(Attribute.TRANSPORT_ORDER_PROPERTY.name(), null, new TransportOrderPropertyUpdate(key, value));
    }

    public void commandEnqueued(@Nonnull MovementCommand enqueuedCommand) {
        this.getPropertyChangeSupport().firePropertyChange(Attribute.COMMAND_ENQUEUED.name(), null, enqueuedCommand);
    }

    public void commandSent(@Nonnull MovementCommand sentCommand) {
        this.getPropertyChangeSupport().firePropertyChange(Attribute.COMMAND_SENT.name(), null, sentCommand);
    }

    public void commandExecuted(@Nonnull MovementCommand executedCommand) {
        this.getPropertyChangeSupport().firePropertyChange(Attribute.COMMAND_EXECUTED.name(), null, executedCommand);
    }

    public void commandFailed(@Nonnull MovementCommand failedCommand) {
        this.getPropertyChangeSupport().firePropertyChange(Attribute.COMMAND_FAILED.name(), null, failedCommand);
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        return this.pcs;
    }

    public static enum Attribute {
        COMM_ADAPTER_ENABLED,
        COMM_ADAPTER_CONNECTED,
        POSITION,
        PRECISE_POSITION,
        ORIENTATION_ANGLE,
        ENERGY_LEVEL,
        LOAD_HANDLING_DEVICES,
        STATE,
        LENGTH,
        USER_NOTIFICATION,
        COMM_ADAPTER_EVENT,
        COMMAND_ENQUEUED,
        COMMAND_SENT,
        COMMAND_EXECUTED,
        COMMAND_FAILED,
        VEHICLE_PROPERTY,
        TRANSPORT_ORDER_PROPERTY;

    }

    public static class VehiclePropertyUpdate
    extends PropertyUpdate {
        public VehiclePropertyUpdate(String key, String value) {
            super(key, value);
        }
    }

    public static class TransportOrderPropertyUpdate
    extends PropertyUpdate {
        public TransportOrderPropertyUpdate(String key, String value) {
            super(key, value);
        }
    }

    public static class PropertyUpdate {
        private final String key;
        private final String value;

        public PropertyUpdate(String key, String value) {
            this.key = Objects.requireNonNull(key, "key");
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

