/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.drivers.vehicle;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.components.Lifecycle;
import org.opentcs.components.kernel.Scheduler;
import org.opentcs.data.model.TCSResource;
import org.opentcs.data.order.DriveOrder;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.drivers.vehicle.AdapterCommand;
import org.opentcs.drivers.vehicle.MovementCommand;
import org.opentcs.util.ExplainedBoolean;

public interface VehicleController
extends Lifecycle,
Scheduler.Client {
    default public void setTransportOrder(@Nonnull TransportOrder newOrder) throws IllegalArgumentException {
    }

    @Deprecated
    default public void setDriveOrder(@Nonnull DriveOrder newOrder, @Nonnull Map<String, String> orderProperties) throws IllegalStateException {
    }

    @Deprecated
    default public void updateDriveOrder(@Nonnull DriveOrder newOrder, @Nonnull Map<String, String> orderProperties) throws IllegalStateException {
    }

    default public void abortTransportOrder(boolean immediate) {
        if (immediate) {
            this.clearDriveOrder();
        } else {
            this.abortDriveOrder();
        }
    }

    @Deprecated
    default public void clearDriveOrder() {
    }

    @Deprecated
    default public void abortDriveOrder() {
    }

    @Deprecated
    default public void clearCommandQueue() {
    }

    @Nonnull
    default public ExplainedBoolean canProcess(@Nonnull TransportOrder order) {
        return this.canProcess(order.getFutureDriveOrders().stream().map(driveOrder -> driveOrder.getDestination().getOperation()).collect(Collectors.toList()));
    }

    @Nonnull
    @Deprecated
    default public ExplainedBoolean canProcess(@Nonnull List<String> operations) {
        return new ExplainedBoolean(false, "VehicleController default implementation");
    }

    default public void onVehiclePaused(boolean paused) {
    }

    public void sendCommAdapterMessage(@Nullable Object var1);

    public void sendCommAdapterCommand(@Nonnull AdapterCommand var1);

    @Nonnull
    public Queue<MovementCommand> getCommandsSent();

    @Nonnull
    default public Optional<MovementCommand> getInteractionsPendingCommand() {
        return Optional.empty();
    }

    default public boolean mayAllocateNow(@Nonnull Set<TCSResource<?>> resources) {
        return false;
    }
}

