/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.drivers.vehicle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import org.opentcs.data.model.Vehicle;
import org.opentcs.drivers.vehicle.AdapterCommand;
import org.opentcs.drivers.vehicle.MovementCommand;
import org.opentcs.drivers.vehicle.VehicleCommAdapter;
import org.opentcs.drivers.vehicle.VehicleProcessModel;
import org.opentcs.drivers.vehicle.management.VehicleProcessModelTO;
import org.opentcs.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicVehicleCommAdapter
implements VehicleCommAdapter,
PropertyChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(BasicVehicleCommAdapter.class);
    private final VehicleProcessModel vehicleModel;
    private final int commandQueueCapacity;
    private final int sentQueueCapacity;
    private final String rechargeOperation;
    private final Executor executor;
    private boolean initialized;
    private boolean enabled;
    private final Runnable commandDispatcherTask = new CommandDispatcherTask();
    private final Queue<MovementCommand> commandQueue = new LinkedBlockingQueue<MovementCommand>();
    private final Queue<MovementCommand> sentQueue = new LinkedBlockingQueue<MovementCommand>();

    @Deprecated
    public BasicVehicleCommAdapter(VehicleProcessModel vehicleModel, int commandQueueCapacity, int sentQueueCapacity, String rechargeOperation, Executor executor) {
        this.vehicleModel = Objects.requireNonNull(vehicleModel, "vehicleModel");
        this.commandQueueCapacity = Assertions.checkInRange(commandQueueCapacity, 0, Integer.MAX_VALUE, "commandQueueCapacity");
        this.sentQueueCapacity = Assertions.checkInRange(sentQueueCapacity, 0, Integer.MAX_VALUE, "sentQueueCapacity");
        this.rechargeOperation = Objects.requireNonNull(rechargeOperation, "rechargeOperation");
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    public BasicVehicleCommAdapter(VehicleProcessModel vehicleModel, int commandQueueCapacity, int sentQueueCapacity, String rechargeOperation, ScheduledExecutorService executor) {
        this(vehicleModel, commandQueueCapacity, sentQueueCapacity, rechargeOperation, (Executor)executor);
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            LOG.debug("{}: Already initialized.", (Object)this.getName());
            return;
        }
        this.getProcessModel().addPropertyChangeListener(this);
        this.initialized = true;
    }

    @Override
    public void terminate() {
        if (!this.initialized) {
            LOG.debug("{}: Not initialized.", (Object)this.getName());
            return;
        }
        this.getProcessModel().removePropertyChangeListener(this);
        this.initialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public synchronized void enable() {
        if (this.isEnabled()) {
            return;
        }
        LOG.info("Vehicle comm adapter is being enabled: {}", (Object)this.getName());
        this.connectVehicle();
        this.enabled = true;
        this.getProcessModel().setCommAdapterEnabled(true);
    }

    @Override
    public synchronized void disable() {
        if (!this.isEnabled()) {
            return;
        }
        LOG.info("Vehicle comm adapter is being disabled: {}", (Object)this.getName());
        this.disconnectVehicle();
        this.enabled = false;
        this.getProcessModel().setCommAdapterEnabled(false);
        this.getProcessModel().setVehicleState(Vehicle.State.UNKNOWN);
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public VehicleProcessModel getProcessModel() {
        return this.vehicleModel;
    }

    @Override
    public VehicleProcessModelTO createTransferableProcessModel() {
        return this.createCustomTransferableProcessModel().setVehicleName(this.getProcessModel().getName()).setCommAdapterConnected(this.getProcessModel().isCommAdapterConnected()).setCommAdapterEnabled(this.getProcessModel().isCommAdapterEnabled()).setEnergyLevel(this.getProcessModel().getVehicleEnergyLevel()).setLoadHandlingDevices(this.getProcessModel().getVehicleLoadHandlingDevices()).setNotifications(this.getProcessModel().getNotifications()).setOrientationAngle(this.getProcessModel().getVehicleOrientationAngle()).setPrecisePosition(this.getProcessModel().getVehiclePrecisePosition()).setVehiclePosition(this.getProcessModel().getVehiclePosition()).setVehicleState(this.getProcessModel().getVehicleState()).setLength(this.getProcessModel().getVehicleLength());
    }

    @Override
    public int getCommandQueueCapacity() {
        return this.commandQueueCapacity;
    }

    @Override
    public synchronized Queue<MovementCommand> getCommandQueue() {
        return this.commandQueue;
    }

    @Override
    public boolean canAcceptNextCommand() {
        return this.getCommandQueue().size() + this.getSentQueue().size() < this.getCommandQueueCapacity();
    }

    @Override
    public int getSentQueueCapacity() {
        return this.sentQueueCapacity;
    }

    @Override
    public synchronized Queue<MovementCommand> getSentQueue() {
        return this.sentQueue;
    }

    @Override
    public String getRechargeOperation() {
        return this.rechargeOperation;
    }

    @Override
    public synchronized boolean enqueueCommand(MovementCommand newCommand) {
        Objects.requireNonNull(newCommand, "newCommand");
        boolean commandAdded = false;
        if (this.getCommandQueue().size() < this.getCommandQueueCapacity()) {
            LOG.debug("{}: Adding command: {}", (Object)this.getName(), (Object)newCommand);
            this.getCommandQueue().add(newCommand);
            commandAdded = true;
        }
        if (commandAdded) {
            this.getProcessModel().commandEnqueued(newCommand);
        }
        return commandAdded;
    }

    @Override
    public synchronized void clearCommandQueue() {
        if (!this.getCommandQueue().isEmpty()) {
            this.getCommandQueue().clear();
        }
        this.getSentQueue().clear();
    }

    @Override
    public void execute(AdapterCommand command) {
        command.execute(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.COMMAND_ENQUEUED.name()) || Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.COMMAND_EXECUTED.name())) {
            this.executor.execute(this.commandDispatcherTask);
        }
    }

    public String getName() {
        return this.getProcessModel().getName();
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public abstract void sendCommand(MovementCommand var1) throws IllegalArgumentException;

    protected synchronized boolean canSendNextCommand() {
        return this.getSentQueue().size() < this.sentQueueCapacity && !this.getCommandQueue().isEmpty();
    }

    protected abstract void connectVehicle();

    protected abstract void disconnectVehicle();

    protected abstract boolean isVehicleConnected();

    protected VehicleProcessModelTO createCustomTransferableProcessModel() {
        return new VehicleProcessModelTO();
    }

    private class CommandDispatcherTask
    implements Runnable {
        CommandDispatcherTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BasicVehicleCommAdapter basicVehicleCommAdapter = BasicVehicleCommAdapter.this;
            synchronized (basicVehicleCommAdapter) {
                if (!BasicVehicleCommAdapter.this.isEnabled()) {
                    LOG.debug("{}: Not enabled, skipping.", (Object)BasicVehicleCommAdapter.this.getName());
                    return;
                }
                if (!BasicVehicleCommAdapter.this.canSendNextCommand()) {
                    LOG.debug("{}: Cannot send another command, skipping.", (Object)BasicVehicleCommAdapter.this.getName());
                    return;
                }
                MovementCommand curCmd = BasicVehicleCommAdapter.this.getCommandQueue().poll();
                if (curCmd == null) {
                    LOG.debug("{}: Nothing to send, skipping.", (Object)BasicVehicleCommAdapter.this.getName());
                    return;
                }
                try {
                    LOG.debug("{}: Sending command: {}", (Object)BasicVehicleCommAdapter.this.getName(), (Object)curCmd);
                    BasicVehicleCommAdapter.this.sendCommand(curCmd);
                    BasicVehicleCommAdapter.this.getSentQueue().add(curCmd);
                    BasicVehicleCommAdapter.this.getProcessModel().commandSent(curCmd);
                }
                catch (IllegalArgumentException exc) {
                    LOG.warn("{}: Failed sending command {}", new Object[]{BasicVehicleCommAdapter.this.getName(), curCmd, exc});
                    BasicVehicleCommAdapter.this.getProcessModel().commandFailed(curCmd);
                }
            }
        }
    }
}

