/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.order;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.util.Assertions;

public class OrderSequence
extends TCSObject<OrderSequence>
implements Serializable {
    @Nonnull
    private final String type;
    private final List<TCSObjectReference<TransportOrder>> orders;
    private final int finishedIndex;
    private final boolean complete;
    private final boolean finished;
    private final boolean failureFatal;
    private final TCSObjectReference<Vehicle> intendedVehicle;
    private final TCSObjectReference<Vehicle> processingVehicle;

    public OrderSequence(String name) {
        super(name);
        this.type = "-";
        this.orders = List.of();
        this.finishedIndex = -1;
        this.complete = false;
        this.finished = false;
        this.failureFatal = false;
        this.intendedVehicle = null;
        this.processingVehicle = null;
    }

    private OrderSequence(String name, Map<String, String> properties, ObjectHistory history, String type, TCSObjectReference<Vehicle> intendedVehicle, List<TCSObjectReference<TransportOrder>> orders, int finishedIndex, boolean complete, boolean failureFatal, boolean finished, TCSObjectReference<Vehicle> processingVehicle) {
        super(name, properties, history);
        this.type = Objects.requireNonNull(type, "type");
        this.intendedVehicle = intendedVehicle;
        this.orders = new ArrayList<TCSObjectReference<TransportOrder>>((Collection)Objects.requireNonNull(orders, "orders"));
        this.finishedIndex = finishedIndex;
        this.complete = complete;
        this.failureFatal = failureFatal;
        this.finished = finished;
        this.processingVehicle = processingVehicle;
    }

    public OrderSequence withProperty(String key, String value) {
        return new OrderSequence(this.getName(), this.propertiesWith(key, value), this.getHistory(), this.type, this.intendedVehicle, this.orders, this.finishedIndex, this.complete, this.failureFatal, this.finished, this.processingVehicle);
    }

    public OrderSequence withProperties(Map<String, String> properties) {
        return new OrderSequence(this.getName(), properties, this.getHistory(), this.type, this.intendedVehicle, this.orders, this.finishedIndex, this.complete, this.failureFatal, this.finished, this.processingVehicle);
    }

    @Override
    public TCSObject<OrderSequence> withHistoryEntry(ObjectHistory.Entry entry) {
        return new OrderSequence(this.getName(), this.getProperties(), this.getHistory().withEntryAppended(entry), this.type, this.intendedVehicle, this.orders, this.finishedIndex, this.complete, this.failureFatal, this.finished, this.processingVehicle);
    }

    @Override
    public TCSObject<OrderSequence> withHistory(ObjectHistory history) {
        return new OrderSequence(this.getName(), this.getProperties(), history, this.type, this.intendedVehicle, this.orders, this.finishedIndex, this.complete, this.failureFatal, this.finished, this.processingVehicle);
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    public OrderSequence withType(String type) {
        return new OrderSequence(this.getName(), this.getProperties(), this.getHistory(), type, this.intendedVehicle, this.orders, this.finishedIndex, this.complete, this.failureFatal, this.finished, this.processingVehicle);
    }

    public List<TCSObjectReference<TransportOrder>> getOrders() {
        return Collections.unmodifiableList(this.orders);
    }

    public OrderSequence withOrder(TCSObjectReference<TransportOrder> order) {
        Assertions.checkArgument(!this.complete, "Sequence complete, cannot add order");
        Assertions.checkArgument(!this.orders.contains(order), "Sequence already contains order %s", order);
        return new OrderSequence(this.getName(), this.getProperties(), this.getHistory(), this.type, this.intendedVehicle, this.ordersWithAppended(order), this.finishedIndex, this.complete, this.failureFatal, this.finished, this.processingVehicle);
    }

    public TCSObjectReference<TransportOrder> getNextUnfinishedOrder() {
        if (this.finished) {
            return null;
        }
        if (this.finishedIndex + 1 >= this.orders.size()) {
            return null;
        }
        return this.orders.get(this.finishedIndex + 1);
    }

    public int getFinishedIndex() {
        return this.finishedIndex;
    }

    public OrderSequence withFinishedIndex(int finishedIndex) {
        Assertions.checkInRange(finishedIndex, 0, this.orders.size() - 1, "finishedIndex");
        return new OrderSequence(this.getName(), this.getProperties(), this.getHistory(), this.type, this.intendedVehicle, this.orders, finishedIndex, this.complete, this.failureFatal, this.finished, this.processingVehicle);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public OrderSequence withComplete(boolean complete) {
        return new OrderSequence(this.getName(), this.getProperties(), this.getHistory(), this.type, this.intendedVehicle, this.orders, this.finishedIndex, complete, this.failureFatal, this.finished, this.processingVehicle);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public OrderSequence withFinished(boolean finished) {
        return new OrderSequence(this.getName(), this.getProperties(), this.getHistory(), this.type, this.intendedVehicle, this.orders, this.finishedIndex, this.complete, this.failureFatal, finished, this.processingVehicle);
    }

    public boolean isFailureFatal() {
        return this.failureFatal;
    }

    public OrderSequence withFailureFatal(boolean failureFatal) {
        return new OrderSequence(this.getName(), this.getProperties(), this.getHistory(), this.type, this.intendedVehicle, this.orders, this.finishedIndex, this.complete, failureFatal, this.finished, this.processingVehicle);
    }

    public TCSObjectReference<Vehicle> getIntendedVehicle() {
        return this.intendedVehicle;
    }

    public OrderSequence withIntendedVehicle(TCSObjectReference<Vehicle> intendedVehicle) {
        return new OrderSequence(this.getName(), this.getProperties(), this.getHistory(), this.type, intendedVehicle, this.orders, this.finishedIndex, this.complete, this.failureFatal, this.finished, this.processingVehicle);
    }

    public TCSObjectReference<Vehicle> getProcessingVehicle() {
        return this.processingVehicle;
    }

    public OrderSequence withProcessingVehicle(TCSObjectReference<Vehicle> processingVehicle) {
        return new OrderSequence(this.getName(), this.getProperties(), this.getHistory(), this.type, this.intendedVehicle, this.orders, this.finishedIndex, this.complete, this.failureFatal, this.finished, processingVehicle);
    }

    private List<TCSObjectReference<TransportOrder>> ordersWithAppended(@Nonnull TCSObjectReference<TransportOrder> order) {
        ArrayList<TCSObjectReference<TransportOrder>> result = new ArrayList<TCSObjectReference<TransportOrder>>(this.orders.size() + 1);
        result.addAll(this.orders);
        result.add(order);
        return result;
    }
}

