/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Couple;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.Path;
import org.opentcs.data.model.TCSResource;
import org.opentcs.data.model.Triple;
import org.opentcs.data.model.Vehicle;
import org.opentcs.util.Assertions;

public class Point
extends TCSResource<Point>
implements Serializable {
    private final Triple position;
    private final Type type;
    private final double vehicleOrientationAngle;
    private final Set<TCSObjectReference<Path>> incomingPaths;
    private final Set<TCSObjectReference<Path>> outgoingPaths;
    private final Set<Location.Link> attachedLinks;
    private final TCSObjectReference<Vehicle> occupyingVehicle;
    private final Layout layout;

    public Point(String name) {
        super(name);
        this.position = new Triple(0L, 0L, 0L);
        this.type = Type.HALT_POSITION;
        this.vehicleOrientationAngle = Double.NaN;
        this.incomingPaths = new HashSet<TCSObjectReference<Path>>();
        this.outgoingPaths = new HashSet<TCSObjectReference<Path>>();
        this.attachedLinks = new HashSet<Location.Link>();
        this.occupyingVehicle = null;
        this.layout = new Layout();
    }

    private Point(String name, Map<String, String> properties, ObjectHistory history, Triple position, Type type, double vehicleOrientationAngle, Set<TCSObjectReference<Path>> incomingPaths, Set<TCSObjectReference<Path>> outgoingPaths, Set<Location.Link> attachedLinks, TCSObjectReference<Vehicle> occupyingVehicle, Layout layout) {
        super(name, properties, history);
        this.position = Objects.requireNonNull(position, "position");
        this.type = Objects.requireNonNull(type, "type");
        Assertions.checkArgument(Double.isNaN(vehicleOrientationAngle) || vehicleOrientationAngle >= -360.0 && vehicleOrientationAngle <= 360.0, "angle not in [-360..360]: %s", vehicleOrientationAngle);
        this.vehicleOrientationAngle = vehicleOrientationAngle;
        this.incomingPaths = Point.setWithoutNullValues(Objects.requireNonNull(incomingPaths, "incomingPaths"));
        this.outgoingPaths = Point.setWithoutNullValues(Objects.requireNonNull(outgoingPaths, "outgoingPaths"));
        this.attachedLinks = Point.setWithoutNullValues(Objects.requireNonNull(attachedLinks, "attachedLinks"));
        this.occupyingVehicle = occupyingVehicle;
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    public Point withProperty(String key, String value) {
        return new Point(this.getName(), this.propertiesWith(key, value), this.getHistory(), this.position, this.type, this.vehicleOrientationAngle, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.layout);
    }

    public Point withProperties(Map<String, String> properties) {
        return new Point(this.getName(), properties, this.getHistory(), this.position, this.type, this.vehicleOrientationAngle, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.layout);
    }

    @Override
    public TCSObject<Point> withHistoryEntry(ObjectHistory.Entry entry) {
        return new Point(this.getName(), this.getProperties(), this.getHistory().withEntryAppended(entry), this.position, this.type, this.vehicleOrientationAngle, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.layout);
    }

    @Override
    public TCSObject<Point> withHistory(ObjectHistory history) {
        return new Point(this.getName(), this.getProperties(), history, this.position, this.type, this.vehicleOrientationAngle, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.layout);
    }

    public Triple getPosition() {
        return this.position;
    }

    public Point withPosition(Triple position) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), position, this.type, this.vehicleOrientationAngle, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.layout);
    }

    public double getVehicleOrientationAngle() {
        return this.vehicleOrientationAngle;
    }

    public Point withVehicleOrientationAngle(double vehicleOrientationAngle) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.position, this.type, vehicleOrientationAngle, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.layout);
    }

    public Type getType() {
        return this.type;
    }

    public Point withType(Type type) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.position, type, this.vehicleOrientationAngle, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.layout);
    }

    public boolean isParkingPosition() {
        return this.type.equals((Object)Type.PARK_POSITION);
    }

    public boolean isHaltingPosition() {
        return this.type.equals((Object)Type.PARK_POSITION) || this.type.equals((Object)Type.HALT_POSITION);
    }

    public TCSObjectReference<Vehicle> getOccupyingVehicle() {
        return this.occupyingVehicle;
    }

    public Point withOccupyingVehicle(TCSObjectReference<Vehicle> occupyingVehicle) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.position, this.type, this.vehicleOrientationAngle, this.incomingPaths, this.outgoingPaths, this.attachedLinks, occupyingVehicle, this.layout);
    }

    public Set<TCSObjectReference<Path>> getIncomingPaths() {
        return Collections.unmodifiableSet(this.incomingPaths);
    }

    public Point withIncomingPaths(Set<TCSObjectReference<Path>> incomingPaths) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.position, this.type, this.vehicleOrientationAngle, incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.layout);
    }

    public Set<TCSObjectReference<Path>> getOutgoingPaths() {
        return Collections.unmodifiableSet(this.outgoingPaths);
    }

    public Point withOutgoingPaths(Set<TCSObjectReference<Path>> outgoingPaths) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.position, this.type, this.vehicleOrientationAngle, this.incomingPaths, outgoingPaths, this.attachedLinks, this.occupyingVehicle, this.layout);
    }

    public Set<Location.Link> getAttachedLinks() {
        return Collections.unmodifiableSet(this.attachedLinks);
    }

    public Point withAttachedLinks(Set<Location.Link> attachedLinks) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.position, this.type, this.vehicleOrientationAngle, this.incomingPaths, this.outgoingPaths, attachedLinks, this.occupyingVehicle, this.layout);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public Point withLayout(Layout layout) {
        return new Point(this.getName(), this.getProperties(), this.getHistory(), this.position, this.type, this.vehicleOrientationAngle, this.incomingPaths, this.outgoingPaths, this.attachedLinks, this.occupyingVehicle, layout);
    }

    public static enum Type {
        REPORT_POSITION,
        HALT_POSITION,
        PARK_POSITION;

    }

    public static class Layout
    implements Serializable {
        private final Couple position;
        private final Couple labelOffset;
        private final int layerId;

        public Layout() {
            this(new Couple(0L, 0L), new Couple(0L, 0L), 0);
        }

        public Layout(Couple position, Couple labelOffset, int layerId) {
            this.position = Objects.requireNonNull(position, "position");
            this.labelOffset = Objects.requireNonNull(labelOffset, "labelOffset");
            this.layerId = layerId;
        }

        public Couple getPosition() {
            return this.position;
        }

        public Layout withPosition(Couple position) {
            return new Layout(position, this.labelOffset, this.layerId);
        }

        public Couple getLabelOffset() {
            return this.labelOffset;
        }

        public Layout withLabelOffset(Couple labelOffset) {
            return new Layout(this.position, labelOffset, this.layerId);
        }

        public int getLayerId() {
            return this.layerId;
        }

        public Layout withLayerId(int layerId) {
            return new Layout(this.position, this.labelOffset, layerId);
        }
    }
}

