/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to.peripherals;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.access.to.CreationTO;
import org.opentcs.access.to.peripherals.PeripheralOperationCreationTO;

public class PeripheralJobCreationTO
extends CreationTO
implements Serializable {
    private final boolean incompleteName;
    @Nonnull
    private final String reservationToken;
    @Nullable
    private final String relatedVehicleName;
    @Nullable
    private final String relatedTransportOrderName;
    @Nonnull
    private final PeripheralOperationCreationTO peripheralOperation;

    public PeripheralJobCreationTO(@Nonnull String name, @Nonnull String reservationToken, @Nonnull PeripheralOperationCreationTO peripheralOperation) {
        super(name);
        this.incompleteName = false;
        this.reservationToken = Objects.requireNonNull(reservationToken, "reservationToken");
        this.relatedVehicleName = null;
        this.relatedTransportOrderName = null;
        this.peripheralOperation = Objects.requireNonNull(peripheralOperation, "peripheralOperation");
    }

    private PeripheralJobCreationTO(@Nonnull String name, @Nonnull Map<String, String> properties, boolean incompleteName, @Nonnull String reservationToken, @Nullable String relatedVehicleName, @Nullable String relatedTransportOrderName, @Nonnull PeripheralOperationCreationTO peripheralOperation) {
        super(name, properties);
        this.incompleteName = incompleteName;
        this.reservationToken = Objects.requireNonNull(reservationToken, "reservationToken");
        this.relatedVehicleName = relatedVehicleName;
        this.relatedTransportOrderName = relatedTransportOrderName;
        this.peripheralOperation = Objects.requireNonNull(peripheralOperation, "peripheralOperation");
    }

    @Override
    public PeripheralJobCreationTO withName(@Nonnull String name) {
        return new PeripheralJobCreationTO(name, this.getModifiableProperties(), this.incompleteName, this.reservationToken, this.relatedVehicleName, this.relatedTransportOrderName, this.peripheralOperation);
    }

    @Override
    public PeripheralJobCreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new PeripheralJobCreationTO(this.getName(), properties, this.incompleteName, this.reservationToken, this.relatedVehicleName, this.relatedTransportOrderName, this.peripheralOperation);
    }

    @Override
    public PeripheralJobCreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new PeripheralJobCreationTO(this.getName(), this.propertiesWith(key, value), this.incompleteName, this.reservationToken, this.relatedVehicleName, this.relatedTransportOrderName, this.peripheralOperation);
    }

    public boolean hasIncompleteName() {
        return this.incompleteName;
    }

    public PeripheralJobCreationTO withIncompleteName(boolean incompleteName) {
        return new PeripheralJobCreationTO(this.getName(), this.getModifiableProperties(), incompleteName, this.reservationToken, this.relatedVehicleName, this.relatedTransportOrderName, this.peripheralOperation);
    }

    public String getReservationToken() {
        return this.reservationToken;
    }

    public PeripheralJobCreationTO withReservationToken(String reservationToken) {
        return new PeripheralJobCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, reservationToken, this.relatedVehicleName, this.relatedTransportOrderName, this.peripheralOperation);
    }

    @Nullable
    public String getRelatedVehicleName() {
        return this.relatedVehicleName;
    }

    public PeripheralJobCreationTO withRelatedVehicleName(@Nullable String relatedVehicleName) {
        return new PeripheralJobCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, this.reservationToken, relatedVehicleName, this.relatedTransportOrderName, this.peripheralOperation);
    }

    @Nullable
    public String getRelatedTransportOrderName() {
        return this.relatedTransportOrderName;
    }

    public PeripheralJobCreationTO withRelatedTransportOrderName(@Nullable String relatedTransportOrderName) {
        return new PeripheralJobCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, this.reservationToken, this.relatedVehicleName, relatedTransportOrderName, this.peripheralOperation);
    }

    public PeripheralOperationCreationTO getPeripheralOperation() {
        return this.peripheralOperation;
    }

    public PeripheralJobCreationTO withPeripheralOperation(PeripheralOperationCreationTO peripheralOperation) {
        return new PeripheralJobCreationTO(this.getName(), this.getModifiableProperties(), this.incompleteName, this.reservationToken, this.relatedVehicleName, this.relatedTransportOrderName, peripheralOperation);
    }
}

