/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to.model;

import java.awt.Color;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.access.to.CreationTO;
import org.opentcs.util.Assertions;

public class VehicleCreationTO
extends CreationTO
implements Serializable {
    private final int length;
    private final int energyLevelCritical;
    private final int energyLevelGood;
    private final int energyLevelFullyRecharged;
    private final int energyLevelSufficientlyRecharged;
    private final int maxVelocity;
    private final int maxReverseVelocity;
    private final Layout layout;

    public VehicleCreationTO(@Nonnull String name) {
        super(name);
        this.length = 1000;
        this.energyLevelCritical = 30;
        this.energyLevelGood = 90;
        this.energyLevelFullyRecharged = 90;
        this.energyLevelSufficientlyRecharged = 30;
        this.maxVelocity = 1000;
        this.maxReverseVelocity = 1000;
        this.layout = new Layout();
    }

    private VehicleCreationTO(@Nonnull String name, @Nonnull Map<String, String> properties, int length, int energyLevelCritical, int energyLevelGood, int energyLevelFullyRecharged, int energyLevelSufficientlyRecharged, int maxVelocity, int maxReverseVelocity, @Nonnull Layout layout) {
        super(name, properties);
        this.length = length;
        this.energyLevelCritical = energyLevelCritical;
        this.energyLevelGood = energyLevelGood;
        this.energyLevelFullyRecharged = energyLevelFullyRecharged;
        this.energyLevelSufficientlyRecharged = energyLevelSufficientlyRecharged;
        this.maxVelocity = maxVelocity;
        this.maxReverseVelocity = maxReverseVelocity;
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    @Override
    public VehicleCreationTO withName(@Nonnull String name) {
        return new VehicleCreationTO(name, this.getModifiableProperties(), this.length, this.energyLevelCritical, this.energyLevelGood, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.layout);
    }

    @Override
    public VehicleCreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new VehicleCreationTO(this.getName(), properties, this.length, this.energyLevelCritical, this.energyLevelGood, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.layout);
    }

    @Override
    public VehicleCreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new VehicleCreationTO(this.getName(), this.propertiesWith(key, value), this.length, this.energyLevelCritical, this.energyLevelGood, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.layout);
    }

    public int getLength() {
        return this.length;
    }

    public VehicleCreationTO withLength(int length) {
        Assertions.checkArgument(length >= 1, "length must be at least 1: " + length);
        return new VehicleCreationTO(this.getName(), this.getModifiableProperties(), length, this.energyLevelCritical, this.energyLevelGood, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.layout);
    }

    public int getEnergyLevelCritical() {
        return this.energyLevelCritical;
    }

    public VehicleCreationTO withEnergyLevelCritical(int energyLevelCritical) {
        Assertions.checkInRange(energyLevelCritical, 0, 100);
        return new VehicleCreationTO(this.getName(), this.getModifiableProperties(), this.length, energyLevelCritical, this.energyLevelGood, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.layout);
    }

    public int getEnergyLevelGood() {
        return this.energyLevelGood;
    }

    public VehicleCreationTO withEnergyLevelGood(int energyLevelGood) {
        Assertions.checkInRange(energyLevelGood, 0, 100);
        return new VehicleCreationTO(this.getName(), this.getModifiableProperties(), this.length, this.energyLevelCritical, energyLevelGood, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.layout);
    }

    public int getEnergyLevelFullyRecharged() {
        return this.energyLevelFullyRecharged;
    }

    public VehicleCreationTO withEnergyLevelFullyRecharged(int energyLevelFullyRecharged) {
        Assertions.checkInRange(energyLevelFullyRecharged, 0, 100);
        return new VehicleCreationTO(this.getName(), this.getModifiableProperties(), this.length, this.energyLevelCritical, this.energyLevelGood, energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.layout);
    }

    public int getEnergyLevelSufficientlyRecharged() {
        return this.energyLevelSufficientlyRecharged;
    }

    public VehicleCreationTO withEnergyLevelSufficientlyRecharged(int energyLevelSufficientlyRecharged) {
        Assertions.checkInRange(energyLevelSufficientlyRecharged, 0, 100);
        return new VehicleCreationTO(this.getName(), this.getModifiableProperties(), this.length, this.energyLevelCritical, this.energyLevelGood, this.energyLevelFullyRecharged, energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, this.layout);
    }

    public int getMaxVelocity() {
        return this.maxVelocity;
    }

    public VehicleCreationTO withMaxVelocity(int maxVelocity) {
        Assertions.checkInRange(maxVelocity, 0, Integer.MAX_VALUE);
        return new VehicleCreationTO(this.getName(), this.getModifiableProperties(), this.length, this.energyLevelCritical, this.energyLevelGood, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, maxVelocity, this.maxReverseVelocity, this.layout);
    }

    public int getMaxReverseVelocity() {
        return this.maxReverseVelocity;
    }

    public VehicleCreationTO withMaxReverseVelocity(int maxReverseVelocity) {
        Assertions.checkInRange(maxReverseVelocity, 0, Integer.MAX_VALUE);
        return new VehicleCreationTO(this.getName(), this.getModifiableProperties(), this.length, this.energyLevelCritical, this.energyLevelGood, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, maxReverseVelocity, this.layout);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public VehicleCreationTO withLayout(Layout layout) {
        return new VehicleCreationTO(this.getName(), this.getModifiableProperties(), this.length, this.energyLevelCritical, this.energyLevelGood, this.energyLevelFullyRecharged, this.energyLevelSufficientlyRecharged, this.maxVelocity, this.maxReverseVelocity, layout);
    }

    public String toString() {
        return "VehicleCreationTO{name=" + this.getName() + ", length=" + this.length + ", energyLevelCritical=" + this.energyLevelCritical + ", energyLevelGood=" + this.energyLevelGood + ", energyLevelFullyRecharged=" + this.energyLevelFullyRecharged + ", energyLevelSufficientlyRecharged=" + this.energyLevelSufficientlyRecharged + ", maxVelocity=" + this.maxVelocity + ", maxReverseVelocity=" + this.maxReverseVelocity + ", layout=" + this.layout + ", properties=" + this.getProperties() + "}";
    }

    public static class Layout
    implements Serializable {
        private final Color routeColor;

        public Layout() {
            this(Color.RED);
        }

        public Layout(Color routeColor) {
            this.routeColor = Objects.requireNonNull(routeColor, "routeColor");
        }

        public Color getRouteColor() {
            return this.routeColor;
        }

        public Layout withRouteColor(Color routeColor) {
            return new Layout(routeColor);
        }

        public String toString() {
            return "Layout{routeColor=" + this.routeColor + "}";
        }
    }
}

