/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.access.to.CreationTO;
import org.opentcs.data.model.visualization.LocationRepresentation;

public class LocationTypeCreationTO
extends CreationTO
implements Serializable {
    private final List<String> allowedOperations;
    private final List<String> allowedPeripheralOperations;
    private final Layout layout;

    public LocationTypeCreationTO(@Nonnull String name) {
        super(name);
        this.allowedOperations = List.of();
        this.allowedPeripheralOperations = List.of();
        this.layout = new Layout();
    }

    private LocationTypeCreationTO(@Nonnull String name, @Nonnull Map<String, String> properties, @Nonnull List<String> allowedOperations, @Nonnull List<String> allowedPeripheralOperations, @Nonnull Layout layout) {
        super(name, properties);
        this.allowedOperations = Objects.requireNonNull(allowedOperations, "allowedOperations");
        this.allowedPeripheralOperations = Objects.requireNonNull(allowedPeripheralOperations, "allowedPeripheralOperations");
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    @Nonnull
    public List<String> getAllowedOperations() {
        return Collections.unmodifiableList(this.allowedOperations);
    }

    public LocationTypeCreationTO withAllowedOperations(@Nonnull List<String> allowedOperations) {
        return new LocationTypeCreationTO(this.getName(), this.getModifiableProperties(), allowedOperations, this.allowedPeripheralOperations, this.layout);
    }

    @Nonnull
    public List<String> getAllowedPeripheralOperations() {
        return Collections.unmodifiableList(this.allowedPeripheralOperations);
    }

    public LocationTypeCreationTO withAllowedPeripheralOperations(@Nonnull List<String> allowedPeripheralOperations) {
        return new LocationTypeCreationTO(this.getName(), this.getModifiableProperties(), this.allowedOperations, allowedPeripheralOperations, this.layout);
    }

    @Override
    public LocationTypeCreationTO withName(@Nonnull String name) {
        return new LocationTypeCreationTO(name, this.getProperties(), this.allowedOperations, this.allowedPeripheralOperations, this.layout);
    }

    @Override
    public LocationTypeCreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new LocationTypeCreationTO(this.getName(), properties, this.allowedOperations, this.allowedPeripheralOperations, this.layout);
    }

    @Override
    public LocationTypeCreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new LocationTypeCreationTO(this.getName(), this.propertiesWith(key, value), this.allowedOperations, this.allowedPeripheralOperations, this.layout);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public LocationTypeCreationTO withLayout(Layout layout) {
        return new LocationTypeCreationTO(this.getName(), this.getModifiableProperties(), this.allowedOperations, this.allowedPeripheralOperations, layout);
    }

    public String toString() {
        return "LocationTypeCreationTO{name=" + this.getName() + ", allowedOperations=" + this.allowedOperations + ", allowedPeripheralOperations" + this.allowedPeripheralOperations + ", layout=" + this.layout + ", properties=" + this.getProperties() + "}";
    }

    public static class Layout
    implements Serializable {
        private final LocationRepresentation locationRepresentation;

        public Layout() {
            this(LocationRepresentation.NONE);
        }

        public Layout(LocationRepresentation locationRepresentation) {
            this.locationRepresentation = Objects.requireNonNull(locationRepresentation, "locationRepresentation");
        }

        public LocationRepresentation getLocationRepresentation() {
            return this.locationRepresentation;
        }

        public Layout withLocationRepresentation(LocationRepresentation locationRepresentation) {
            return new Layout(locationRepresentation);
        }

        public String toString() {
            return "Layout{locationRepresentation=" + this.locationRepresentation + "}";
        }
    }
}

