/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi.services;

import java.rmi.RemoteException;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.rmi.services.AbstractRemoteServiceProxy;
import org.opentcs.access.rmi.services.RemoteDispatcherService;
import org.opentcs.components.kernel.services.DispatcherService;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.ReroutingType;
import org.opentcs.data.order.TransportOrder;

class RemoteDispatcherServiceProxy
extends AbstractRemoteServiceProxy<RemoteDispatcherService>
implements DispatcherService {
    RemoteDispatcherServiceProxy() {
    }

    @Override
    public void dispatch() throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteDispatcherService)this.getRemoteService()).dispatch(this.getClientId());
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void withdrawByVehicle(TCSObjectReference<Vehicle> vehicleRef, boolean immediateAbort) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteDispatcherService)this.getRemoteService()).withdrawByVehicle(this.getClientId(), vehicleRef, immediateAbort);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void withdrawByTransportOrder(TCSObjectReference<TransportOrder> ref, boolean immediateAbort) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteDispatcherService)this.getRemoteService()).withdrawByTransportOrder(this.getClientId(), ref, immediateAbort);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void reroute(TCSObjectReference<Vehicle> ref, ReroutingType reroutingType) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteDispatcherService)this.getRemoteService()).reroute(this.getClientId(), ref, reroutingType);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }
}

