/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util;

public class Assertions {
    private Assertions() {
    }

    public static void checkArgument(boolean expression, String errorMessage) throws IllegalArgumentException {
        Assertions.checkArgument(expression, errorMessage, new Object[]{null});
    }

    public static void checkArgument(boolean expression, String messageTemplate, Object ... messageArgs) throws IllegalArgumentException {
        if (!expression) {
            throw new IllegalArgumentException(String.format(String.valueOf(messageTemplate), messageArgs));
        }
    }

    public static void checkState(boolean expression, String errorMessage) throws IllegalStateException {
        Assertions.checkState(expression, errorMessage, new Object[]{null});
    }

    public static void checkState(boolean expression, String messageTemplate, Object ... messageArgs) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(String.format(String.valueOf(messageTemplate), messageArgs));
        }
    }

    public static int checkInRange(int value, int minimum, int maximum) throws IllegalArgumentException {
        return Assertions.checkInRange(value, minimum, maximum, "value");
    }

    public static int checkInRange(int value, int minimum, int maximum, String valueName) throws IllegalArgumentException {
        if (value < minimum || value > maximum) {
            throw new IllegalArgumentException(String.format("%s is not in [%d..%d]: %d", String.valueOf(valueName), minimum, maximum, value));
        }
        return value;
    }

    public static long checkInRange(long value, long minimum, long maximum) throws IllegalArgumentException {
        return Assertions.checkInRange(value, minimum, maximum, "value");
    }

    public static long checkInRange(long value, long minimum, long maximum, String valueName) throws IllegalArgumentException {
        if (value < minimum || value > maximum) {
            throw new IllegalArgumentException(String.format("%s is not in [%d..%d]: %d", String.valueOf(valueName), minimum, maximum, value));
        }
        return value;
    }
}

