/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.drivers.peripherals;

import java.util.Objects;
import org.opentcs.data.model.PeripheralInformation;
import org.opentcs.drivers.peripherals.PeripheralCommAdapter;
import org.opentcs.drivers.peripherals.PeripheralProcessModel;
import org.opentcs.drivers.peripherals.management.PeripheralProcessModelEvent;
import org.opentcs.util.event.EventHandler;

public abstract class BasicPeripheralCommAdapter
implements PeripheralCommAdapter {
    private final EventHandler eventHandler;
    private PeripheralProcessModel processModel;
    private boolean initialized;

    public BasicPeripheralCommAdapter(PeripheralProcessModel processModel, EventHandler eventHandler) {
        this.processModel = Objects.requireNonNull(processModel, "processModel");
        this.eventHandler = Objects.requireNonNull(eventHandler, "eventHandler");
    }

    @Override
    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.setProcessModel(this.getProcessModel().withState(PeripheralInformation.State.UNKNOWN));
        this.sendProcessModelChangedEvent(PeripheralProcessModel.Attribute.STATE);
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.initialized = false;
    }

    @Override
    public void enable() {
        if (this.isEnabled()) {
            return;
        }
        this.connectPeripheral();
        this.setProcessModel(this.getProcessModel().withCommAdapterEnabled(true));
        this.sendProcessModelChangedEvent(PeripheralProcessModel.Attribute.COMM_ADAPTER_ENABLED);
    }

    @Override
    public boolean isEnabled() {
        return this.processModel.isCommAdapterEnabled();
    }

    @Override
    public void disable() {
        if (!this.isEnabled()) {
            return;
        }
        this.disconnectPeripheral();
        this.setProcessModel(this.getProcessModel().withCommAdapterEnabled(false).withState(PeripheralInformation.State.UNKNOWN));
        this.sendProcessModelChangedEvent(PeripheralProcessModel.Attribute.COMM_ADAPTER_ENABLED);
        this.sendProcessModelChangedEvent(PeripheralProcessModel.Attribute.STATE);
    }

    @Override
    public PeripheralProcessModel getProcessModel() {
        return this.processModel;
    }

    protected void setProcessModel(PeripheralProcessModel processModel) {
        this.processModel = processModel;
    }

    protected EventHandler getEventHandler() {
        return this.eventHandler;
    }

    protected void sendProcessModelChangedEvent(PeripheralProcessModel.Attribute attributeChanged) {
        this.eventHandler.onEvent(new PeripheralProcessModelEvent(this.processModel.getLocation(), attributeChanged.name(), this.processModel));
    }

    protected abstract void connectPeripheral();

    protected abstract void disconnectPeripheral();
}

