/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.model;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.peripherals.PeripheralJob;

public class PeripheralInformation
implements Serializable {
    @Nullable
    private final String reservationToken;
    @Nonnull
    private final State state;
    @Nonnull
    private final ProcState procState;
    @Nullable
    private final TCSObjectReference<PeripheralJob> peripheralJob;

    public PeripheralInformation() {
        this(null, State.NO_PERIPHERAL, ProcState.IDLE, null);
    }

    private PeripheralInformation(@Nullable String reservationToken, @Nonnull State state, @Nonnull ProcState procState, @Nullable TCSObjectReference<PeripheralJob> peripheralJob) {
        this.reservationToken = reservationToken;
        this.state = Objects.requireNonNull(state, "state");
        this.procState = Objects.requireNonNull(procState, "procState");
        this.peripheralJob = peripheralJob;
    }

    @Nullable
    public String getReservationToken() {
        return this.reservationToken;
    }

    public PeripheralInformation withReservationToken(@Nullable String reservationToken) {
        return new PeripheralInformation(reservationToken, this.state, this.procState, this.peripheralJob);
    }

    @Nonnull
    public State getState() {
        return this.state;
    }

    public PeripheralInformation withState(@Nonnull State state) {
        return new PeripheralInformation(this.reservationToken, state, this.procState, this.peripheralJob);
    }

    @Nonnull
    public ProcState getProcState() {
        return this.procState;
    }

    public PeripheralInformation withProcState(@Nonnull ProcState procState) {
        return new PeripheralInformation(this.reservationToken, this.state, procState, this.peripheralJob);
    }

    @Nullable
    public TCSObjectReference<PeripheralJob> getPeripheralJob() {
        return this.peripheralJob;
    }

    public PeripheralInformation withPeripheralJob(@Nullable TCSObjectReference<PeripheralJob> peripheralJob) {
        return new PeripheralInformation(this.reservationToken, this.state, this.procState, peripheralJob);
    }

    public static enum State {
        NO_PERIPHERAL,
        UNKNOWN,
        UNAVAILABLE,
        ERROR,
        IDLE,
        EXECUTING;

    }

    public static enum ProcState {
        IDLE,
        PROCESSING_JOB;

    }
}

