/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.util.Assertions;

public class ObjectHistory
implements Serializable {
    private final List<Entry> entries;

    public ObjectHistory() {
        this(new ArrayList<Entry>());
    }

    private ObjectHistory(List<Entry> entries) {
        this.entries = Collections.unmodifiableList(Objects.requireNonNull(entries, "entries"));
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public ObjectHistory withEntries(List<Entry> entries) {
        return new ObjectHistory(entries);
    }

    public ObjectHistory withEntryAppended(Entry entry) {
        Objects.requireNonNull(entry, "entry");
        ArrayList<Entry> newEntries = new ArrayList<Entry>(this.entries.size() + 1);
        newEntries.addAll(this.entries);
        newEntries.add(entry);
        return new ObjectHistory(newEntries);
    }

    public String toString() {
        return "ObjectHistory{entries=" + this.entries + "}";
    }

    public static class Entry
    implements Serializable {
        private final Instant timestamp;
        private final String eventCode;
        private final Object supplement;

        public Entry(Instant timestamp, String eventCode, Object supplement) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
            this.eventCode = Objects.requireNonNull(eventCode, "eventCode");
            this.supplement = Objects.requireNonNull(supplement, "supplement");
            Assertions.checkArgument(supplement instanceof Serializable, "supplement is not serializable");
        }

        public Entry(Instant timestamp, String eventCode) {
            this(timestamp, eventCode, "");
        }

        public Entry(String eventCode, Object supplement) {
            this(Instant.now(), eventCode, supplement);
        }

        public Entry(String eventCode) {
            this(eventCode, (Object)"");
        }

        @Nonnull
        public Instant getTimestamp() {
            return this.timestamp;
        }

        @Nonnull
        public String getEventCode() {
            return this.eventCode;
        }

        @Nonnull
        public Object getSupplement() {
            return this.supplement;
        }

        public String toString() {
            return "Entry{timestamp=" + this.timestamp + ", eventCode=" + this.eventCode + ", supplement=" + this.supplement + "}";
        }
    }
}

