/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.components.kernel;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.components.Lifecycle;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.DriveOrder;
import org.opentcs.data.order.Route;
import org.opentcs.data.order.TransportOrder;

public interface Router
extends Lifecycle {
    public static final String PROPKEY_ROUTING_GROUP = "tcs:routingGroup";
    public static final String PROPKEY_ROUTING_COST_FORWARD = "tcs:routingCostForward";
    public static final String PROPKEY_ROUTING_COST_REVERSE = "tcs:routingCostReverse";

    public void topologyChanged();

    @Nonnull
    public Set<Vehicle> checkRoutability(@Nonnull TransportOrder var1);

    @Nonnull
    public Optional<List<DriveOrder>> getRoute(@Nonnull Vehicle var1, @Nonnull Point var2, @Nonnull TransportOrder var3);

    @Nonnull
    public Optional<Route> getRoute(@Nonnull Vehicle var1, @Nonnull Point var2, @Nonnull Point var3);

    public long getCosts(@Nonnull Vehicle var1, @Nonnull Point var2, @Nonnull Point var3);

    public long getCostsByPointRef(@Nonnull Vehicle var1, @Nonnull TCSObjectReference<Point> var2, @Nonnull TCSObjectReference<Point> var3);

    public void selectRoute(@Nonnull Vehicle var1, @Nullable List<DriveOrder> var2);

    @Nonnull
    public Map<Vehicle, List<DriveOrder>> getSelectedRoutes();

    @Nonnull
    public Set<Point> getTargetedPoints();
}

