/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi.services;

import java.rmi.Remote;
import java.rmi.RemoteException;
import org.opentcs.access.rmi.ClientID;
import org.opentcs.access.rmi.services.ServiceListener;
import org.opentcs.components.kernel.services.ServiceUnavailableException;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectUnknownException;

abstract class AbstractRemoteServiceProxy<R extends Remote> {
    private static final String SERVICE_UNAVAILABLE_MESSAGE = "Remote service unreachable";
    private ClientID clientId;
    private R remoteService;
    private ServiceListener serviceListener;

    AbstractRemoteServiceProxy() {
    }

    ClientID getClientId() {
        return this.clientId;
    }

    AbstractRemoteServiceProxy<R> setClientId(ClientID clientId) {
        this.clientId = clientId;
        return this;
    }

    R getRemoteService() {
        return this.remoteService;
    }

    AbstractRemoteServiceProxy<R> setRemoteService(R remoteService) {
        this.remoteService = remoteService;
        return this;
    }

    ServiceListener getServiceListener() {
        return this.serviceListener;
    }

    public AbstractRemoteServiceProxy<R> setServiceListener(ServiceListener serviceListener) {
        this.serviceListener = serviceListener;
        return this;
    }

    boolean isLoggedIn() {
        return this.getClientId() != null && this.getRemoteService() != null;
    }

    void checkServiceAvailability() throws ServiceUnavailableException {
        if (!this.isLoggedIn()) {
            throw new ServiceUnavailableException(SERVICE_UNAVAILABLE_MESSAGE);
        }
    }

    RuntimeException findSuitableExceptionFor(RemoteException ex) {
        if (ex.getCause() instanceof ObjectUnknownException) {
            return (ObjectUnknownException)ex.getCause();
        }
        if (ex.getCause() instanceof ObjectExistsException) {
            return (ObjectExistsException)ex.getCause();
        }
        if (ex.getCause() instanceof IllegalArgumentException) {
            return (IllegalArgumentException)ex.getCause();
        }
        if (this.getServiceListener() != null) {
            this.getServiceListener().onServiceUnavailable();
        }
        return new ServiceUnavailableException(SERVICE_UNAVAILABLE_MESSAGE, ex);
    }
}

