/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi.factories;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.opentcs.access.SslParameterSet;

class SecureSslContextFactory
implements Serializable {
    private static final String KEY_TRUST_MANAGEMENT_ALGORITHM = "SunX509";
    private static final String SSL_CONTEXT_PROTOCOL = "TLSv1.2";
    private final SslParameterSet sslParameterSet;

    public SecureSslContextFactory(SslParameterSet sslParameterSet) {
        this.sslParameterSet = Objects.requireNonNull(sslParameterSet, "sslParameterSet");
    }

    public SSLContext createClientContext() throws IllegalStateException {
        SSLContext context = null;
        try {
            KeyStore ts = KeyStore.getInstance(this.sslParameterSet.getKeystoreType());
            ts.load(new FileInputStream(this.sslParameterSet.getTruststoreFile()), this.sslParameterSet.getTruststorePassword().toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(KEY_TRUST_MANAGEMENT_ALGORITHM);
            tmf.init(ts);
            context = SSLContext.getInstance(SSL_CONTEXT_PROTOCOL);
            context.init(null, tmf.getTrustManagers(), null);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new IllegalStateException("Error creating the client's ssl context", ex);
        }
        return context;
    }

    public SSLContext createServerContext() throws IllegalStateException {
        SSLContext context = null;
        try {
            KeyStore ks = KeyStore.getInstance(this.sslParameterSet.getKeystoreType());
            ks.load(new FileInputStream(this.sslParameterSet.getKeystoreFile()), this.sslParameterSet.getKeystorePassword().toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KEY_TRUST_MANAGEMENT_ALGORITHM);
            kmf.init(ks, this.sslParameterSet.getKeystorePassword().toCharArray());
            context = SSLContext.getInstance(SSL_CONTEXT_PROTOCOL);
            context.init(kmf.getKeyManagers(), null, null);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            throw new IllegalStateException("Error creating the server's ssl context", ex);
        }
        return context;
    }
}

