/*
 * Decompiled with CFR 0.152.
 */
package nl.tue.buildingsmart.schema;

import java.util.ArrayList;
import java.util.HashMap;
import nl.tue.buildingsmart.schema.Attribute;
import nl.tue.buildingsmart.schema.BaseType;
import nl.tue.buildingsmart.schema.BinaryType;
import nl.tue.buildingsmart.schema.DefinedType;
import nl.tue.buildingsmart.schema.EntityDefinition;
import nl.tue.buildingsmart.schema.ExplicitAttribute;
import nl.tue.buildingsmart.schema.IntegerType;
import nl.tue.buildingsmart.schema.LogicalType;
import nl.tue.buildingsmart.schema.RealType;
import nl.tue.buildingsmart.schema.Schema;
import nl.tue.buildingsmart.schema.StringType;

public class SchemaDefinition
implements Schema {
    private String name;
    private HashMap<String, EntityDefinition> entitiesBN = new HashMap();
    private ArrayList<EntityDefinition> entities = new ArrayList();
    private HashMap<String, DefinedType> typesBN = new HashMap();
    private ArrayList<DefinedType> types = new ArrayList();
    private HashMap<EntityDefinition, ArrayList<EntityDefinition>> parents = new HashMap();
    private HashMap<EntityDefinition, ArrayList<EntityDefinition>> entityRelations = new HashMap();
    private byte[] schemaData;

    public boolean addEntity(EntityDefinition ent) {
        String entName = ent.getName();
        this.entities.add(ent);
        this.entitiesBN.put(entName.toUpperCase(), ent);
        return true;
    }

    public boolean addType(DefinedType type) {
        this.types.add(type);
        this.typesBN.put(type.getName().toUpperCase(), type);
        return true;
    }

    public DefinedType getTypeBN(String name) {
        return this.typesBN.get(name.toUpperCase());
    }

    public void constructEntityRelationsMap() {
        this.entityRelations.clear();
        for (EntityDefinition ent : this.entities) {
            if (ent.getAttributes().isEmpty()) continue;
            for (Attribute at : ent.getAttributes()) {
                BaseType bt;
                if (!(at instanceof ExplicitAttribute) || !((bt = ((ExplicitAttribute)at).getDomain()) instanceof EntityDefinition)) continue;
                ArrayList<EntityDefinition> rels = this.entityRelations.get(ent);
                if (rels == null) {
                    this.entityRelations.put(ent, new ArrayList());
                    rels = this.entityRelations.get(ent);
                }
                rels.add((EntityDefinition)bt);
            }
        }
    }

    public void constructHirarchyMap() {
        this.parents.clear();
        this.parents = new HashMap();
        for (EntityDefinition ent : this.entities) {
            if (ent.getSupertypes().isEmpty()) continue;
            for (EntityDefinition parent : ent.getSupertypes()) {
                if (this.parents.get(parent) == null) {
                    this.parents.put(parent, new ArrayList());
                }
                ArrayList<EntityDefinition> children = this.parents.get(parent);
                children.add(ent);
                parent.addSubtype(ent);
            }
        }
    }

    public BaseType getBaseTypeBN(String name) {
        BaseType bt = this.typesBN.get(name.toUpperCase());
        if (bt == null) {
            bt = this.entitiesBN.get(name.toUpperCase());
        }
        if (bt == null && name.equalsIgnoreCase("real")) {
            return new RealType();
        }
        if (bt == null && name.equalsIgnoreCase("integer")) {
            return new IntegerType();
        }
        if (bt == null && name.equalsIgnoreCase("binary")) {
            return new BinaryType();
        }
        if (bt == null && name.equalsIgnoreCase("string")) {
            return new StringType();
        }
        if (bt == null && name.equalsIgnoreCase("logical")) {
            return new LogicalType();
        }
        return bt;
    }

    @Override
    public EntityDefinition getEntityBN(String name) {
        return this.entitiesBN.get(name.toUpperCase());
    }

    @Override
    public EntityDefinition getEntityBNNoCaseConvert(String name) {
        return this.entitiesBN.get(name);
    }

    public HashMap<String, EntityDefinition> getEnitiesBN() {
        return this.entitiesBN;
    }

    public void setEnitiesBN(HashMap<String, EntityDefinition> enitiesBN) {
        this.entitiesBN = enitiesBN;
    }

    public ArrayList<EntityDefinition> getEntities() {
        return this.entities;
    }

    public void setEntities(ArrayList<EntityDefinition> entities) {
        this.entities = entities;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HashMap<String, DefinedType> getTypesBN() {
        return this.typesBN;
    }

    public void setTypesBN(HashMap<String, DefinedType> types) {
        this.typesBN = types;
    }

    public ArrayList<DefinedType> getTypes() {
        return this.types;
    }

    public void setTypes(ArrayList<DefinedType> typesBN) {
        this.types = typesBN;
    }

    public SchemaDefinition(String name) throws Exception {
        this.name = name;
    }

    public SchemaDefinition() {
    }

    public HashMap<EntityDefinition, ArrayList<EntityDefinition>> getParents() {
        return this.parents;
    }

    public ArrayList<EntityDefinition> getEntityChildren(EntityDefinition ent) {
        return this.parents.get(ent);
    }

    public ArrayList<EntityDefinition> getEntityRelations(EntityDefinition ent) {
        if (this.entityRelations.get(ent) == null) {
            return new ArrayList<EntityDefinition>();
        }
        return this.entityRelations.get(ent);
    }

    public byte[] getSchemaData() {
        return this.schemaData;
    }

    public void setSchemaData(byte[] schemaData) {
        this.schemaData = schemaData;
    }
}

