/*
 * Decompiled with CFR 0.152.
 */
package nl.tue.buildingsmart.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import nl.tue.buildingsmart.schema.Attribute;
import nl.tue.buildingsmart.schema.DerivedAttribute2;
import nl.tue.buildingsmart.schema.NamedType;

public class EntityDefinition
extends NamedType {
    private ArrayList<EntityDefinition> supertypes = new ArrayList();
    private HashMap<String, EntityDefinition> supertypesBN = new HashMap();
    private ArrayList<Attribute> attributes = new ArrayList();
    private HashMap<String, Attribute> attributesBN = new HashMap();
    private HashMap<String, Attribute> attributesPlusSuperBN;
    private ArrayList<Attribute> attributesPlusSuper;
    private ArrayList<EntityDefinition> subtypes = new ArrayList();
    private final Map<String, DerivedAttribute2> derivedAttributes = new HashMap<String, DerivedAttribute2>();
    private final Set<String> derivedAttributesOverride = new HashSet<String>();
    boolean complex;
    boolean instantiable;
    boolean independent;

    public EntityDefinition(String name) {
        super(name);
    }

    public boolean isDerived(String name) {
        return this.derivedAttributes.containsKey(name);
    }

    public String toString() {
        return this.getName();
    }

    public boolean addAttribute(Attribute a) {
        a.setParent_entity(this);
        this.attributes.add(a);
        this.attributesBN.put(a.getName(), a);
        return true;
    }

    public void addDerived(DerivedAttribute2 attribute, boolean firstOccurance) {
        if (!this.derivedAttributes.containsKey(attribute.getName())) {
            this.derivedAttributes.put(attribute.getName(), attribute);
        } else if (firstOccurance) {
            this.derivedAttributes.put(attribute.getName(), attribute);
        }
        for (EntityDefinition entityDefinition : this.supertypes) {
            if (entityDefinition.getAttributeBNWithSuper(attribute.getName()) == null) continue;
            this.derivedAttributesOverride.add(attribute.getName());
        }
        this.doSubtypes(attribute);
    }

    private void doSubtypes(DerivedAttribute2 attribute) {
        for (EntityDefinition entityDefinition : this.subtypes) {
            entityDefinition.addDerived(new DerivedAttribute2(attribute.getName(), attribute.getType(), attribute.getExpressCode(), attribute.isCollection(), true), false);
            entityDefinition.doSubtypes(attribute);
        }
    }

    public Attribute getAttributeBN(String name) {
        return this.attributesBN.get(name);
    }

    public Attribute getAttributeBNWithSuper(String name) {
        if (this.attributesBN.containsKey(name)) {
            return this.attributesBN.get(name);
        }
        if (this.attributesPlusSuperBN == null) {
            this.getAttributesCached(true);
        }
        if (this.attributesPlusSuperBN.containsKey(name)) {
            return this.attributesPlusSuperBN.get(name);
        }
        return null;
    }

    public boolean addSupertype(EntityDefinition parent) {
        this.supertypes.add(parent);
        this.supertypesBN.put(parent.getName(), parent);
        return true;
    }

    public ArrayList<Attribute> getAttributes() {
        return this.attributes;
    }

    public ArrayList<Attribute> getAttributes(boolean returnInherited) {
        if (!returnInherited) {
            return this.getAttributes();
        }
        ArrayList<Attribute> tempAttribs = new ArrayList();
        Iterator<EntityDefinition> parentIter = this.getSupertypes().iterator();
        while (parentIter.hasNext()) {
            tempAttribs = parentIter.next().getAttributes(true);
        }
        Iterator<Attribute> attribIter = this.getAttributes().iterator();
        while (attribIter.hasNext()) {
            tempAttribs.add(attribIter.next());
        }
        return tempAttribs;
    }

    public ArrayList<Attribute> getAttributesCached(boolean returnInherited) {
        if (!returnInherited) {
            return this.getAttributes();
        }
        if (this.attributesPlusSuper == null) {
            this.attributesPlusSuper = this.getAttributes(true);
            this.attributesPlusSuperBN = new HashMap();
            for (Attribute attribute : this.attributesPlusSuper) {
                this.attributesPlusSuperBN.put(attribute.getName(), attribute);
            }
        }
        return this.attributesPlusSuper;
    }

    public void setAttributes(ArrayList<Attribute> attributes) {
        this.attributes = attributes;
    }

    public HashMap<String, Attribute> getAttributesBN() {
        return this.attributesBN;
    }

    public void setAttributesBN(HashMap<String, Attribute> attributesBN) {
        this.attributesBN = attributesBN;
    }

    public ArrayList<EntityDefinition> getSupertypes() {
        return this.supertypes;
    }

    public void setSupertypes(ArrayList<EntityDefinition> supertypes) {
        this.supertypes = supertypes;
    }

    public HashMap<String, EntityDefinition> getSupertypesBN() {
        return this.supertypesBN;
    }

    public void setSupertypesBN(HashMap<String, EntityDefinition> supertypesBN) {
        this.supertypesBN = supertypesBN;
    }

    public ArrayList<EntityDefinition> getSubtypes() {
        if (this.subtypes == null) {
            this.subtypes = new ArrayList();
        }
        return this.subtypes;
    }

    public void setSubtypes(ArrayList<EntityDefinition> subtypes) {
        this.subtypes = subtypes;
    }

    public void addSubtype(EntityDefinition subClass) {
        this.subtypes.add(subClass);
    }

    public boolean isInstantiable() {
        return this.instantiable;
    }

    public void setInstantiable(boolean instantiable) {
        this.instantiable = instantiable;
    }

    public Map<String, DerivedAttribute2> getDerivedAttributes() {
        return this.derivedAttributes;
    }

    public boolean isDerivedOverride(String name) {
        return this.derivedAttributesOverride.contains(name);
    }
}

