/*
 * Decompiled with CFR 0.152.
 */
package nl.tue.buildingsmart.emf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nl.tue.buildingsmart.emf.DerivedReader;
import nl.tue.buildingsmart.express.parser.ExpressSchemaParser;
import nl.tue.buildingsmart.schema.SchemaDefinition;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaLoader.class);
    public static final File DEFAULT_SCHEMA_FILE = new File("../buildingSMARTLibrary/schema" + File.separator + "IFC2X3_TC1.exp");

    private SchemaLoader() {
    }

    public static SchemaDefinition loadIfc2x3tc1() throws IOException {
        return SchemaLoader.load("IFC2X3_TC1.exp");
    }

    public static SchemaDefinition loadIfc4() throws IOException {
        return SchemaLoader.load("IFC4.exp");
    }

    private static SchemaDefinition load(String name) throws IOException {
        InputStream inputStream = SchemaLoader.class.getResourceAsStream("/schema/" + name);
        if (inputStream != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
            SchemaDefinition schema = null;
            ExpressSchemaParser schemaParser = new ExpressSchemaParser(new ByteArrayInputStream(baos.toByteArray()));
            schemaParser.parse();
            schema = schemaParser.getSchema();
            schema.setSchemaData(baos.toByteArray());
            new DerivedReader(new ByteArrayInputStream(baos.toByteArray()), schema);
            if (schema != null) {
                LOGGER.info("IFC-Schema successfully loaded from " + name);
            }
            return schema;
        }
        LOGGER.error("Schema not found: " + name);
        return null;
    }
}

