/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client.protocolbuffers;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.http.impl.client.CloseableHttpClient;
import org.bimserver.client.Channel;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.ConnectDisconnectListener;
import org.bimserver.shared.TokenHolder;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.pb.ProtocolBuffersMetaData;
import org.bimserver.shared.pb.ProtocolBuffersReflector;
import org.bimserver.shared.pb.SocketProtocolBuffersChannel;
import org.bimserver.shared.reflector.Reflector;
import org.bimserver.shared.reflector.ReflectorFactory;

public class ProtocolBuffersChannel
extends Channel
implements ConnectDisconnectListener {
    private SocketProtocolBuffersChannel protocolBuffersChannel;
    private SServicesMap servicesMap;
    private ReflectorFactory reflectorFactory;
    private String address;
    private int port;
    private ProtocolBuffersMetaData protocolBuffersMetaData;

    public ProtocolBuffersChannel(CloseableHttpClient httpClient, SServicesMap servicesMap, ProtocolBuffersMetaData protocolBuffersMetaData, ReflectorFactory reflectorFactory, String address, int port) {
        super(httpClient);
        this.servicesMap = servicesMap;
        this.protocolBuffersMetaData = protocolBuffersMetaData;
        this.reflectorFactory = reflectorFactory;
        this.address = address;
        this.port = port;
    }

    @Override
    public void connect(TokenHolder tokenHolder) throws ChannelConnectionException {
        this.protocolBuffersChannel = new SocketProtocolBuffersChannel(tokenHolder);
        this.protocolBuffersChannel.registerConnectDisconnectListener((ConnectDisconnectListener)this);
        ProtocolBuffersReflector reflector = new ProtocolBuffersReflector(this.protocolBuffersMetaData, this.servicesMap, this.protocolBuffersChannel);
        for (Class interface1 : this.servicesMap.getInterfaceClasses()) {
            PublicInterface createReflector = this.reflectorFactory.createReflector(interface1, (Reflector)reflector);
            this.add(interface1.getName(), createReflector);
        }
        this.finish((Reflector)reflector, this.reflectorFactory);
        try {
            this.protocolBuffersChannel.connect(new InetSocketAddress(this.address, this.port));
        }
        catch (IOException e) {
            throw new ChannelConnectionException((Exception)e);
        }
    }

    public void connected() {
        this.notifyOfConnect();
    }

    public void disconnected() {
        this.notifyOfDisconnect();
    }

    @Override
    public void disconnect() {
        if (this.protocolBuffersChannel != null) {
            this.protocolBuffersChannel.disconnect();
        }
    }
}

