/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client.json;

import org.bimserver.client.AbstractBimServerClientFactory;
import org.bimserver.client.BimServerClient;
import org.bimserver.client.json.JsonChannel;
import org.bimserver.client.json.JsonSocketReflectorFactory;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.shared.AuthenticationInfo;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.exceptions.BimServerClientException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.reflector.FileBasedReflectorFactoryBuilder;
import org.bimserver.shared.reflector.ReflectorFactory;

public class JsonBimServerClientFactory
extends AbstractBimServerClientFactory {
    private String address;
    private JsonSocketReflectorFactory jsonSocketReflectorFactory;
    private ReflectorFactory reflectorFactory;

    public JsonBimServerClientFactory(String address, SServicesMap servicesMap, JsonSocketReflectorFactory jsonSocketReflectorFactory, ReflectorFactory reflectorFactory, MetaDataManager metaDataManager) {
        super(servicesMap, metaDataManager);
        this.address = address;
        this.jsonSocketReflectorFactory = jsonSocketReflectorFactory;
        this.reflectorFactory = reflectorFactory;
    }

    public JsonBimServerClientFactory(MetaDataManager metaDataManager, String address) throws BimServerClientException {
        super(metaDataManager);
        this.address = address;
        this.jsonSocketReflectorFactory = new JsonSocketReflectorFactory(this.getServicesMap());
        FileBasedReflectorFactoryBuilder reflectorBuilder = new FileBasedReflectorFactoryBuilder();
        this.reflectorFactory = reflectorBuilder.newReflectorFactory();
    }

    public JsonBimServerClientFactory(String address) throws BimServerClientException {
        this(null, address);
    }

    public BimServerClient create(AuthenticationInfo authenticationInfo) throws ServiceException, ChannelConnectionException {
        JsonChannel jsonChannel = new JsonChannel(this.getHttpClient(), this.reflectorFactory, this.jsonSocketReflectorFactory, this.address + "/json", this.getServicesMap());
        BimServerClient bimServerClient = new BimServerClient(this.getMetaDataManager(), this.address, this.getServicesMap(), jsonChannel);
        jsonChannel.connect(bimServerClient);
        bimServerClient.setAuthentication(authenticationInfo);
        bimServerClient.connect();
        return bimServerClient;
    }
}

