/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.xml.serializer;

import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.models.store.ParameterDefinition;
import org.bimserver.models.store.PrimitiveDefinition;
import org.bimserver.models.store.PrimitiveEnum;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.models.store.StringType;
import org.bimserver.models.store.Type;
import org.bimserver.models.store.TypeDefinition;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.serializers.AbstractSerializerPlugin;
import org.bimserver.shared.exceptions.PluginException;

public abstract class IfcXmlSerializerPlugin
extends AbstractSerializerPlugin {
    private boolean initialized = false;

    public String getDescription() {
        return "IfcXmlSerializer";
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsGeometry() {
        return false;
    }

    public void init(PluginManagerInterface pluginManager) throws PluginException {
        this.initialized = true;
    }

    public String getDefaultContentType() {
        return "application/ifcxml";
    }

    public String getDefaultExtension() {
        return "ifcxml";
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public ObjectDefinition getSettingsDefinition() {
        ObjectDefinition settingsDefinition = super.getSettingsDefinition();
        PrimitiveDefinition stringDefinition = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        stringDefinition.setType(PrimitiveEnum.STRING);
        ParameterDefinition zipExtension = StoreFactory.eINSTANCE.createParameterDefinition();
        zipExtension.setName("ZipExtension");
        zipExtension.setDescription("Extension of the downloaded file when using zip compression");
        zipExtension.setType((TypeDefinition)stringDefinition);
        StringType defaultZipExtensionValue = StoreFactory.eINSTANCE.createStringType();
        defaultZipExtensionValue.setValue("ifczip");
        zipExtension.setDefaultValue((Type)defaultZipExtensionValue);
        settingsDefinition.getParameters().add((Object)zipExtension);
        return settingsDefinition;
    }
}

