/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.compare;

import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifc.compare.AbstractModelCompare;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.ifc2x3tc1.IfcRoot;
import org.bimserver.models.ifc2x3tc1.IfcWindow;
import org.bimserver.models.store.CompareContainer;
import org.bimserver.models.store.CompareResult;
import org.bimserver.models.store.CompareType;
import org.bimserver.models.store.ObjectAdded;
import org.bimserver.models.store.ObjectRemoved;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.plugins.modelcompare.ModelCompareException;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;

public class GuidBasedModelCompare
extends AbstractModelCompare {
    public GuidBasedModelCompare(ObjectIDM objectIDM) {
        super(objectIDM);
    }

    public CompareResult compare(IfcModelInterface model1, IfcModelInterface model2, CompareType compareType) throws ModelCompareException {
        CompareResult result = StoreFactory.eINSTANCE.createCompareResult();
        try {
            for (EClassifier eClassifier : Ifc2x3tc1Package.eINSTANCE.getEClassifiers()) {
                IfcRoot eObject2;
                IfcRoot eObject1;
                if (!(eClassifier instanceof EClass) || !Ifc2x3tc1Package.eINSTANCE.getIfcRoot().isSuperTypeOf((EClass)eClassifier)) continue;
                EClass eClass = (EClass)eClassifier;
                for (IdEObject i : model1.getValues()) {
                    if (!(i instanceof IfcWindow)) continue;
                    IfcWindow window = (IfcWindow)i;
                    for (EStructuralFeature feature : window.eClass().getEStructuralFeatures()) {
                        window.eGet(feature);
                    }
                }
                for (String guid : model1.getGuids(eClass)) {
                    eObject1 = model1.getByGuid(guid);
                    eObject2 = model2.getByGuid(guid);
                    if (eObject2 != null || compareType != CompareType.ALL && compareType != CompareType.DELETE) continue;
                    ObjectRemoved objectRemoved = StoreFactory.eINSTANCE.createObjectRemoved();
                    objectRemoved.setDataObject(this.makeDataObject((IdEObject)eObject1));
                    this.getCompareContainer(eObject1.eClass()).getItems().add((Object)objectRemoved);
                }
                for (String guid : model2.getGuids(eClass)) {
                    eObject1 = model1.getByGuid(guid);
                    eObject2 = model2.getByGuid(guid);
                    if (eObject1 == null) {
                        if (compareType != CompareType.ALL && compareType != CompareType.ADD) continue;
                        ObjectAdded objectAdded = StoreFactory.eINSTANCE.createObjectAdded();
                        objectAdded.setDataObject(this.makeDataObject((IdEObject)eObject2));
                        this.getCompareContainer(eObject2.eClass()).getItems().add((Object)objectAdded);
                        continue;
                    }
                    this.compareEObjects(eClass, (IdEObject)eObject1, (IdEObject)eObject2, result, compareType);
                }
            }
        }
        catch (Exception e) {
            throw new ModelCompareException(e);
        }
        for (CompareContainer compareContainer : this.getMap().values()) {
            result.getItems().add((Object)compareContainer);
        }
        return result;
    }
}

