/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.compare;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.models.ifc2x3tc1.IfcRoot;
import org.bimserver.models.store.CompareContainer;
import org.bimserver.models.store.CompareResult;
import org.bimserver.models.store.CompareType;
import org.bimserver.models.store.DataObject;
import org.bimserver.models.store.ListDataValue;
import org.bimserver.models.store.ObjectModified;
import org.bimserver.models.store.ReferenceDataValue;
import org.bimserver.models.store.SimpleDataValue;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.plugins.modelcompare.ModelCompare;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class AbstractModelCompare
implements ModelCompare {
    private final ObjectIDM objectIDM;
    private final Map<EClass, CompareContainer> map = new HashMap<EClass, CompareContainer>();

    public AbstractModelCompare(ObjectIDM objectIDM) {
        this.objectIDM = objectIDM;
    }

    protected DataObject makeDataObject(IdEObject eObject) {
        DataObject dataObject = StoreFactory.eINSTANCE.createDataObject();
        ((IdEObjectImpl)dataObject).setOid(eObject.getOid());
        if (eObject instanceof IfcRoot) {
            IfcRoot ifcRoot = (IfcRoot)eObject;
            dataObject.setName(ifcRoot.getName());
            if (ifcRoot.getGlobalId() != null) {
                dataObject.setGuid(ifcRoot.getGlobalId());
            }
        }
        for (EStructuralFeature eStructuralFeature : eObject.eClass().getEAllStructuralFeatures()) {
            EList values;
            ListDataValue listDataValue;
            Object val = eObject.eGet(eStructuralFeature);
            if (eStructuralFeature instanceof EReference) {
                EReference eReference = (EReference)eStructuralFeature;
                if (eReference.isMany()) {
                    listDataValue = StoreFactory.eINSTANCE.createListDataValue();
                    listDataValue.setFieldName(eReference.getName());
                    values = listDataValue.getValues();
                    for (Object v : (List)val) {
                        IdEObject ref = (IdEObject)v;
                        ReferenceDataValue referenceDataValue = StoreFactory.eINSTANCE.createReferenceDataValue();
                        referenceDataValue.setTypeName(eReference.getEType().getName());
                        ((IdEObjectImpl)referenceDataValue).setOid(ref.getOid());
                        values.add((Object)referenceDataValue);
                    }
                    dataObject.getValues().add((Object)listDataValue);
                    continue;
                }
                IdEObject ref = (IdEObject)val;
                if (ref == null) continue;
                ReferenceDataValue referenceDataValue = StoreFactory.eINSTANCE.createReferenceDataValue();
                referenceDataValue.setFieldName(eReference.getName());
                referenceDataValue.setTypeName(eReference.getEType().getName());
                ((IdEObjectImpl)referenceDataValue).setOid(ref.getOid());
                dataObject.getValues().add((Object)referenceDataValue);
                continue;
            }
            if (!(eStructuralFeature instanceof EAttribute)) continue;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            if (eAttribute.isMany()) {
                listDataValue = StoreFactory.eINSTANCE.createListDataValue();
                listDataValue.setFieldName(eAttribute.getName());
                values = listDataValue.getValues();
                for (Object v : (List)val) {
                    SimpleDataValue simpleDataValue = StoreFactory.eINSTANCE.createSimpleDataValue();
                    simpleDataValue.setFieldName(eAttribute.getName());
                    simpleDataValue.setStringValue(v.toString());
                    values.add((Object)simpleDataValue);
                }
                dataObject.getValues().add((Object)listDataValue);
                continue;
            }
            SimpleDataValue simpleDataValue = StoreFactory.eINSTANCE.createSimpleDataValue();
            simpleDataValue.setFieldName(eAttribute.getName());
            simpleDataValue.setStringValue(val == null ? "null" : val.toString());
        }
        return dataObject;
    }

    protected Map<EClass, CompareContainer> getMap() {
        return this.map;
    }

    protected CompareContainer getCompareContainer(EClass eClass) {
        if (!this.map.containsKey(eClass)) {
            CompareContainer compareContainer = StoreFactory.eINSTANCE.createCompareContainer();
            compareContainer.setType(eClass.getName());
            this.map.put(eClass, compareContainer);
            return compareContainer;
        }
        return this.map.get(eClass);
    }

    protected void compareEObjects(EClass originalQueryClass, IdEObject eObject1, IdEObject eObject2, CompareResult result, CompareType sCompareType) {
        if (eObject1.eClass() != eObject2.eClass()) {
            return;
        }
        EClass eClass = eObject1.eClass();
        if (sCompareType == CompareType.ALL || sCompareType == CompareType.MODIFY) {
            for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
                ObjectModified objectModified;
                if (!this.objectIDM.shouldFollowReference(originalQueryClass, eClass, eStructuralFeature) || eStructuralFeature.getEAnnotation("hidden") != null) continue;
                Object value1 = eObject1.eGet(eStructuralFeature);
                Object value2 = eObject2.eGet(eStructuralFeature);
                if (eStructuralFeature.isMany()) continue;
                if (eStructuralFeature.getEType() instanceof EClass) {
                    Object realVal2;
                    Object realVal1;
                    EClass value1Class;
                    ObjectModified objectModified2;
                    if (value1 == null && value2 == null) continue;
                    if (value1 == null && value2 != null) {
                        EClass value2Class = ((EObject)value2).eClass();
                        if (value2Class.getEAnnotation("wrapped") == null) continue;
                        Object realVal22 = ((EObject)value2).eGet(value2Class.getEStructuralFeature("wrappedValue"));
                        objectModified2 = StoreFactory.eINSTANCE.createObjectModified();
                        objectModified2.setDataObject(this.makeDataObject(eObject1));
                        objectModified2.setFieldName(eStructuralFeature.getName());
                        objectModified2.setOldValue(null);
                        objectModified2.setNewValue(realVal22.toString());
                        this.getCompareContainer(eObject1.eClass()).getItems().add((Object)objectModified2);
                        continue;
                    }
                    if (value1 != null && value2 == null) {
                        value1Class = ((EObject)value1).eClass();
                        if (value1Class.getEAnnotation("wrapped") == null) continue;
                        realVal1 = ((EObject)value1).eGet(value1Class.getEStructuralFeature("wrappedValue"));
                        objectModified2 = StoreFactory.eINSTANCE.createObjectModified();
                        objectModified2.setDataObject(this.makeDataObject(eObject1));
                        objectModified2.setFieldName(eStructuralFeature.getName());
                        objectModified2.setOldValue(realVal1.toString());
                        objectModified2.setNewValue(null);
                        this.getCompareContainer(eObject1.eClass()).getItems().add((Object)objectModified2);
                        continue;
                    }
                    value1Class = ((EObject)value1).eClass();
                    if (((EObject)value1).eClass().getEAnnotation("wrapped") == null || (realVal1 = ((EObject)value1).eGet(value1Class.getEStructuralFeature("wrappedValue"))).equals(realVal2 = ((EObject)value2).eGet(value1Class.getEStructuralFeature("wrappedValue")))) continue;
                    ObjectModified objectModified3 = StoreFactory.eINSTANCE.createObjectModified();
                    objectModified3.setDataObject(this.makeDataObject(eObject1));
                    objectModified3.setFieldName(eStructuralFeature.getName());
                    objectModified3.setOldValue(realVal1.toString());
                    objectModified3.setNewValue(realVal2.toString());
                    this.getCompareContainer(eObject1.eClass()).getItems().add((Object)objectModified3);
                    continue;
                }
                if (!(eStructuralFeature.getEType() instanceof EDataType) || value1 == null && value2 == null) continue;
                if (value1 == null && value2 != null) {
                    objectModified = StoreFactory.eINSTANCE.createObjectModified();
                    objectModified.setDataObject(this.makeDataObject(eObject1));
                    objectModified.setFieldName(eStructuralFeature.getName());
                    objectModified.setOldValue(null);
                    objectModified.setNewValue(value2.toString());
                    this.getCompareContainer(eObject1.eClass()).getItems().add((Object)objectModified);
                    continue;
                }
                if (value1 != null && value2 == null) {
                    objectModified = StoreFactory.eINSTANCE.createObjectModified();
                    objectModified.setDataObject(this.makeDataObject(eObject1));
                    objectModified.setFieldName(eStructuralFeature.getName());
                    objectModified.setOldValue(value1.toString());
                    objectModified.setNewValue(null);
                    this.getCompareContainer(eObject1.eClass()).getItems().add((Object)objectModified);
                    continue;
                }
                if (value1.equals(value2)) continue;
                objectModified = StoreFactory.eINSTANCE.createObjectModified();
                objectModified.setDataObject(this.makeDataObject(eObject1));
                objectModified.setFieldName(eStructuralFeature.getName());
                objectModified.setOldValue(value1.toString());
                objectModified.setNewValue(value2.toString());
                this.getCompareContainer(eObject1.eClass()).getItems().add((Object)objectModified);
            }
        }
    }
}

