/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.formsamples.crud.types.toxicologia;

import javax.annotation.Nonnull;
import org.opensingular.form.SIComposite;
import org.opensingular.form.SInfoType;
import org.opensingular.form.SType;
import org.opensingular.form.STypeComposite;
import org.opensingular.form.STypeList;
import org.opensingular.form.STypeSimple;
import org.opensingular.form.TypeBuilder;
import org.opensingular.form.type.core.STypeBoolean;
import org.opensingular.form.type.core.STypeDecimal;
import org.opensingular.form.type.core.STypeInteger;
import org.opensingular.form.type.core.STypeString;
import org.opensingular.form.type.core.attachment.STypeAttachment;
import org.opensingular.form.util.SingularPredicates;
import org.opensingular.form.view.list.SViewListByTable;
import org.opensingular.formsamples.crud.types.toxicologia.STAtivoAmostra;
import org.opensingular.formsamples.crud.types.toxicologia.ToxicologiaPackage;

@SInfoType(spackage=ToxicologiaPackage.class, name="amostra")
public class STAmostra
extends STypeComposite<SIComposite> {
    public STypeString id;
    public STypeDecimal dose;
    public STypeInteger dat;
    public STypeDecimal loq;
    public STypeDecimal residuo;
    public STAtivoAmostra ativos;
    public STypeBoolean tempoMaior30Dias;
    public STypeAttachment estudoEstabilidade;
    public STypeBoolean metabolito;
    public STypeList<STypeComposite<SIComposite>, SIComposite> metabolitos;

    protected void onLoadType(@Nonnull TypeBuilder tb) {
        this.id = this.addFieldString("id");
        this.dose = this.addFieldDecimal("dose");
        this.dat = this.addFieldInteger("dat");
        this.loq = this.addFieldDecimal("loq");
        this.residuo = this.addFieldDecimal("residuo");
        this.ativos = (STAtivoAmostra)this.addField("ativos", STAtivoAmostra.class);
        this.tempoMaior30Dias = this.addFieldBoolean("tempoMaior30Dias");
        this.estudoEstabilidade = this.addFieldAttachment("estudoEstabilidade");
        this.metabolito = this.addFieldBoolean("metabolito");
        this.metabolitos = this.addFieldListOfComposite("metabolitos", "metabolito");
        STypeString descricaoMetabolito = ((STypeComposite)this.metabolitos.getElementsType()).addFieldString("descricao");
        STypeDecimal loqMetabolito = ((STypeComposite)this.metabolitos.getElementsType()).addFieldDecimal("loqMetabolito");
        STypeDecimal residuoMetabolito = ((STypeComposite)this.metabolitos.getElementsType()).addFieldDecimal("residuoMetabolito");
        this.id.asAtr().label("ID da Amostra").required(ToxicologiaPackage.OBRIGATORIO.booleanValue()).asAtrBootstrap().colPreference(Integer.valueOf(4));
        this.dose.asAtrBootstrap().colPreference(Integer.valueOf(4)).asAtr().label("Dose").required(ToxicologiaPackage.OBRIGATORIO.booleanValue());
        this.dat.asAtr().required(ToxicologiaPackage.OBRIGATORIO.booleanValue()).label("DAT").asAtrBootstrap().colPreference(Integer.valueOf(4));
        this.loq.asAtr().required(ToxicologiaPackage.OBRIGATORIO.booleanValue()).label("LoQ (mg/KG)").fractionalMaxLength(Integer.valueOf(4));
        this.residuo.asAtr().dependsOn(new SType[]{this.loq}).required(ToxicologiaPackage.OBRIGATORIO.booleanValue()).label("Res\u00edduo (mg/KG)").fractionalMaxLength(Integer.valueOf(4));
        this.ativos.asAtr().required(ToxicologiaPackage.OBRIGATORIO.booleanValue()).label("Ingrediente Ativo da Amostra (informados na se\u00e7\u00e3o de ativos)").asAtrBootstrap().colPreference(Integer.valueOf(6));
        this.tempoMaior30Dias.asAtr().label("Tempo Entre An\u00e1lise e Colheita Maior que 30 Dias").asAtrBootstrap().colPreference(Integer.valueOf(6)).newRow();
        this.estudoEstabilidade.asAtr().required(ToxicologiaPackage.OBRIGATORIO.booleanValue()).label("Estudo de Estabilidade (em formato PDF)").dependsOn(new SType[]{this.tempoMaior30Dias}).exists(SingularPredicates.typeValueIsTrue((STypeSimple)this.tempoMaior30Dias));
        this.estudoEstabilidade.asAtr().allowedFileTypes(new String[]{"pdf"});
        this.metabolito.withRadioView().asAtr().required(ToxicologiaPackage.OBRIGATORIO.booleanValue()).label("Metab\u00f3lito");
        this.metabolitos.withMinimumSizeOf(Integer.valueOf(1)).withView(SViewListByTable::new).asAtr().label("Metab\u00f3litos").dependsOn(new SType[]{this.metabolito}).exists(SingularPredicates.typeValueIsTrue((STypeSimple)this.metabolito));
        descricaoMetabolito.asAtr().required(ToxicologiaPackage.OBRIGATORIO.booleanValue()).label("Descri\u00e7\u00e3o");
        loqMetabolito.asAtr().required(ToxicologiaPackage.OBRIGATORIO.booleanValue()).label("LoQ (mg/KG)").fractionalMaxLength(Integer.valueOf(4));
        residuoMetabolito.asAtr().required(ToxicologiaPackage.OBRIGATORIO.booleanValue()).label("Res\u00edduo (mg/KG)").fractionalMaxLength(Integer.valueOf(4));
    }
}

