/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.formsamples.crud.types.antaq;

import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.opensingular.form.SIComposite;
import org.opensingular.form.SInfoType;
import org.opensingular.form.SInstance;
import org.opensingular.form.SType;
import org.opensingular.form.STypeAttachmentList;
import org.opensingular.form.STypeComposite;
import org.opensingular.form.STypeList;
import org.opensingular.form.STypeSimple;
import org.opensingular.form.TypeBuilder;
import org.opensingular.form.type.core.SIString;
import org.opensingular.form.type.core.STypeBoolean;
import org.opensingular.form.type.core.STypeString;
import org.opensingular.form.type.core.attachment.STypeAttachment;
import org.opensingular.form.util.SingularPredicates;
import org.opensingular.form.view.SMultiSelectionByCheckboxView;
import org.opensingular.form.view.SView;
import org.opensingular.form.view.SViewByBlock;
import org.opensingular.formsamples.crud.types.antaq.AntaqPackage;
import org.opensingular.formsamples.crud.types.antaq.Resolucao912Form;

@SInfoType(spackage=AntaqPackage.class, name="HabilitacaoEmpresa")
public class STypeHabilitacaoEmpresa
extends STypeComposite<SIComposite> {
    public static final String PDF = "pdf";
    public STypeComposite<SIComposite> empresaBrasileiraComp;
    public STypeAttachment anexoEmp1;
    public STypeList<STypeString, SIString> cnae;
    public STypeComposite<SIComposite> contratoSocialComp;
    public STypeAttachment anexoContratoSocial2;
    public STypeAttachment anexoContratoSocial3;
    public STypeAttachment anexoContratoSocial4;
    public STypeAttachment anexoContratoSocial5;
    public STypeComposite<SIComposite> demontracoesContabeisComp;
    public STypeAttachment anexoCon1;
    public STypeAttachment anexoCon2;
    public STypeAttachment anexoCon3;
    public STypeComposite<SIComposite> certidoesComp;
    public STypeBoolean enviarDeclaracaoReg;
    public STypeAttachment anexoCert1;
    public STypeAttachment anexoCert2;
    public STypeAttachment anexoCert3;
    public STypeAttachment anexoCert4;
    public STypeAttachment anexoCert5;
    public STypeAttachment anexoCert6;
    public STypeAttachment declaracaoRegularidade;
    public STypeAttachment declaracaoSimplesNacional;
    public STypeAttachmentList outros;

    protected void onLoadType(TypeBuilder tb) {
        this.empresaBrasileiraComp = this.addFieldComposite("empresaBrasileiraComp");
        this.empresaBrasileiraComp.asAtrAnnotation().setAnnotated();
        this.anexoEmp1 = (STypeAttachment)this.empresaBrasileiraComp.addField("anexoEmp1", STypeAttachment.class);
        this.anexoEmp1.asAtr().label("Comprovante de Inscri\u00e7\u00e3o no CNPJ").allowedFileTypes(new String[]{PDF}).required(Resolucao912Form.OBRIGATORIO).asAtrBootstrap().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.cnae = this.empresaBrasileiraComp.addFieldListOf("cnae", STypeString.class);
        this.cnae.asAtr().label("CNAE").required(Resolucao912Form.OBRIGATORIO).asAtrBootstrap().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.cnae.selectionOf(String.class, (SView)new SMultiSelectionByCheckboxView()).selfIdAndDisplay().simpleProviderOf((Serializable[])new String[]{"5021-1/02 - Carga ", "5022-0/02 - Passageiros"});
        this.contratoSocialComp = this.addFieldComposite("contratoSocialComp");
        this.contratoSocialComp.asAtr().subtitle("Pelo menos um dos anexos deve ser enviado.").asAtrAnnotation().setAnnotated();
        this.anexoContratoSocial2 = (STypeAttachment)this.contratoSocialComp.addField("anexoContratoSocial2", STypeAttachment.class);
        this.anexoContratoSocial2.asAtr().allowedFileTypes(new String[]{PDF}).label("Contrato/Estatuto Social").asAtrBootstrap().colPreference(Integer.valueOf(6));
        this.anexoContratoSocial3 = (STypeAttachment)this.contratoSocialComp.addField("anexoContratoSocial3", STypeAttachment.class);
        this.anexoContratoSocial3.asAtr().allowedFileTypes(new String[]{PDF}).label("Declara\u00e7\u00e3o de Firma Individual").asAtrBootstrap().colPreference(Integer.valueOf(6));
        this.anexoContratoSocial4 = (STypeAttachment)this.contratoSocialComp.addField("anexoContratoSocial4", STypeAttachment.class);
        this.anexoContratoSocial4.asAtr().allowedFileTypes(new String[]{PDF}).label("Requerimento de empres\u00e1rio").asAtrBootstrap().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.anexoContratoSocial5 = (STypeAttachment)this.contratoSocialComp.addField("anexoContratoSocial5", STypeAttachment.class);
        this.anexoContratoSocial5.asAtr().allowedFileTypes(new String[]{PDF}).label("Ata de Elei\u00e7\u00e3o dos administradores").subtitle("com mandato em vigor, para as sociedades por a\u00e7\u00f5es").asAtrBootstrap().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.anexoContratoSocial2.asAtr().required(SingularPredicates.allMatches((Predicate[])new Predicate[]{i -> Resolucao912Form.OBRIGATORIO, this.atLeast(1, new STypeAttachment[]{this.anexoContratoSocial2, this.anexoContratoSocial3, this.anexoContratoSocial4, this.anexoContratoSocial5})}));
        this.anexoContratoSocial3.asAtr().required(SingularPredicates.allMatches((Predicate[])new Predicate[]{i -> Resolucao912Form.OBRIGATORIO, this.atLeast(1, new STypeAttachment[]{this.anexoContratoSocial2, this.anexoContratoSocial3, this.anexoContratoSocial4, this.anexoContratoSocial5})}));
        this.anexoContratoSocial4.asAtr().required(SingularPredicates.allMatches((Predicate[])new Predicate[]{i -> Resolucao912Form.OBRIGATORIO, this.atLeast(1, new STypeAttachment[]{this.anexoContratoSocial2, this.anexoContratoSocial3, this.anexoContratoSocial4, this.anexoContratoSocial5})}));
        this.anexoContratoSocial5.asAtr().required(SingularPredicates.allMatches((Predicate[])new Predicate[]{i -> Resolucao912Form.OBRIGATORIO, this.atLeast(1, new STypeAttachment[]{this.anexoContratoSocial2, this.anexoContratoSocial3, this.anexoContratoSocial4, this.anexoContratoSocial5})}));
        this.demontracoesContabeisComp = this.addFieldComposite("demontracoesContabeisComp");
        this.demontracoesContabeisComp.asAtrAnnotation().setAnnotated();
        this.anexoCon1 = (STypeAttachment)this.demontracoesContabeisComp.addField("anexoCon1", STypeAttachment.class);
        this.anexoCon1.asAtr().allowedFileTypes(new String[]{PDF}).label("Balan\u00e7o Patrimonial e demais Demonstra\u00e7\u00f5es Cont\u00e1beis do \u00faltimo Exerc\u00edcio Social").asAtrBootstrap().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.anexoCon2 = (STypeAttachment)this.demontracoesContabeisComp.addField("anexoCon2", STypeAttachment.class);
        this.anexoCon2.asAtr().allowedFileTypes(new String[]{PDF}).label("Balan\u00e7o de abertura no caso de empresa rec\u00e9m criada, relativo a sua constitui\u00e7\u00e3o").asAtrBootstrap().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.anexoCon3 = (STypeAttachment)this.demontracoesContabeisComp.addField("anexoCon3", STypeAttachment.class);
        this.anexoCon3.asAtr().allowedFileTypes(new String[]{PDF}).label("Documenta\u00e7\u00e3o cont\u00e1bil simplificada (somente para Micro Empresas e Empresas de Pequeno Porte optantes do Simples Nacional)").asAtrBootstrap().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.declaracaoSimplesNacional = (STypeAttachment)this.demontracoesContabeisComp.addField("declaracaoSimplesNacional", STypeAttachment.class);
        this.declaracaoSimplesNacional.asAtr().allowedFileTypes(new String[]{PDF}).label("Declara\u00e7\u00e3o de optante pelo Simples Nacional").dependsOn(new SType[]{this.anexoCon3}).exists(p -> !p.findNearest((SType)this.anexoCon3).filter(SIComposite::isEmptyOfData).isPresent()).required(p -> !p.findNearest((SType)this.anexoCon3).filter(SIComposite::isEmptyOfData).isPresent()).asAtrBootstrap().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.anexoCon1.asAtr().required(SingularPredicates.allMatches((Predicate[])new Predicate[]{i -> Resolucao912Form.OBRIGATORIO, this.atLeast(1, new STypeAttachment[]{this.anexoCon1, this.anexoCon2, this.anexoCon3})}));
        this.anexoCon2.asAtr().required(SingularPredicates.allMatches((Predicate[])new Predicate[]{i -> Resolucao912Form.OBRIGATORIO, this.atLeast(1, new STypeAttachment[]{this.anexoCon1, this.anexoCon2, this.anexoCon3})}));
        this.anexoCon3.asAtr().required(SingularPredicates.allMatches((Predicate[])new Predicate[]{i -> Resolucao912Form.OBRIGATORIO, this.atLeast(1, new STypeAttachment[]{this.anexoCon1, this.anexoCon2, this.anexoCon3})}));
        this.certidoesComp = this.addFieldComposite("certidoesComp");
        this.certidoesComp.asAtr().label("Certid\u00f5es").asAtrAnnotation().setAnnotated();
        this.enviarDeclaracaoReg = this.certidoesComp.addFieldBoolean("enviarDeclaracaoReg");
        this.enviarDeclaracaoReg.withRadioView().setInitialValue((Object)Boolean.FALSE).asAtr().label("Deseja enviar a Declara\u00e7\u00e3o de Regularidade ?").required(Resolucao912Form.OBRIGATORIO).asAtrBootstrap().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.declaracaoRegularidade = (STypeAttachment)this.certidoesComp.addField("declaracaoRegularidade", STypeAttachment.class);
        this.declaracaoRegularidade.asAtr().allowedFileTypes(new String[]{PDF}).label("Declara\u00e7\u00e3o de Regularidade").dependsOn(new SType[]{this.enviarDeclaracaoReg}).exists(SingularPredicates.typeValueIsTrueAndNotNull((STypeSimple)this.enviarDeclaracaoReg)).required(i -> i.findNearest((SType)this.enviarDeclaracaoReg).filter(ii -> Boolean.TRUE.equals(ii.getValue())).isPresent()).asAtrBootstrap().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.anexoCert1 = (STypeAttachment)this.certidoesComp.addField("anexoCert1", STypeAttachment.class);
        this.anexoCert1.asAtr().required(SingularPredicates.allMatches((Predicate[])new Predicate[]{i -> Resolucao912Form.OBRIGATORIO, arg_0 -> this.masterDeclaracaoRegularidade(arg_0)})).allowedFileTypes(new String[]{PDF}).label("Certid\u00e3o Negativa de Fal\u00eancia / concordata / recupera\u00e7\u00e3o judicial / recupera\u00e7\u00e3o extrajudicial").asAtrBootstrap().newRow().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.anexoCert2 = (STypeAttachment)this.certidoesComp.addField("anexoCert2", STypeAttachment.class);
        this.anexoCert2.asAtr().required(SingularPredicates.allMatches((Predicate[])new Predicate[]{i -> Resolucao912Form.OBRIGATORIO, arg_0 -> this.masterDeclaracaoRegularidade(arg_0)})).allowedFileTypes(new String[]{PDF}).label("Certid\u00e3o Conjunta Negativa de D\u00e9bitos Relativos a Tributos Federais e a D\u00edvida Ativa da Uni\u00e3o").asAtrBootstrap().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.anexoCert3 = (STypeAttachment)this.certidoesComp.addField("anexoCert3", STypeAttachment.class);
        this.anexoCert3.asAtr().required(SingularPredicates.allMatches((Predicate[])new Predicate[]{i -> Resolucao912Form.OBRIGATORIO, arg_0 -> this.masterDeclaracaoRegularidade(arg_0)})).allowedFileTypes(new String[]{PDF}).label("Prova de regularidade perante a Fazenda Estadual").asAtrBootstrap().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.anexoCert4 = (STypeAttachment)this.certidoesComp.addField("anexoCert4", STypeAttachment.class);
        this.anexoCert4.asAtr().required(SingularPredicates.allMatches((Predicate[])new Predicate[]{i -> Resolucao912Form.OBRIGATORIO, arg_0 -> this.masterDeclaracaoRegularidade(arg_0)})).allowedFileTypes(new String[]{PDF}).label("Prova de regularidade perante a Fazenda Municipal").asAtrBootstrap().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.anexoCert5 = (STypeAttachment)this.certidoesComp.addField("anexoCert5", STypeAttachment.class);
        this.anexoCert5.asAtr().required(SingularPredicates.allMatches((Predicate[])new Predicate[]{i -> Resolucao912Form.OBRIGATORIO, arg_0 -> this.masterDeclaracaoRegularidade(arg_0)})).allowedFileTypes(new String[]{PDF}).label("Prova de regularidade perante o FGTS").asAtrBootstrap().colPreference(Integer.valueOf(6)).asAtrAnnotation().setAnnotated();
        this.anexoCert6 = (STypeAttachment)this.certidoesComp.addField("anexoCert6", STypeAttachment.class);
        this.anexoCert6.asAtr().required(SingularPredicates.allMatches((Predicate[])new Predicate[]{i -> Resolucao912Form.OBRIGATORIO, arg_0 -> this.masterDeclaracaoRegularidade(arg_0)})).allowedFileTypes(new String[]{PDF}).label("Prova de regularidade perante o INSS").asAtrBootstrap().colPreference(Integer.valueOf(6));
        this.outros = this.addFieldListOfAttachment("outros", "outroDocumento");
        this.outros.asAtr().label("Outros").asAtrBootstrap().colPreference(Integer.valueOf(12)).asAtrAnnotation().setAnnotated();
        ((STypeAttachment)this.outros.getElementsType()).asAtr().allowedFileTypes(new String[]{PDF});
        this.withView((SView)new SViewByBlock(), new Consumer[]{v -> v.newBlock("Empresa").add((SType)this.empresaBrasileiraComp).newBlock("Contrato Social (enviar ao menos um)").add((SType)this.contratoSocialComp).newBlock("Balan\u00e7o Patrimonial/Demonstra\u00e7\u00f5es cont\u00e1beis (enviar ao menos um)").add((SType)this.demontracoesContabeisComp).newBlock().add((SType)this.certidoesComp).newBlock("Outras declara\u00e7\u00f5es").add((SType)this.outros)});
    }

    private Predicate<SInstance> atLeast(int quantity, STypeAttachment ... types) {
        Predicate<SInstance> atLeast = t -> {
            int count = 0;
            for (STypeAttachment sType : types) {
                if (t.findNearest((SType)sType).filter(SIComposite::isEmptyOfData).isPresent()) continue;
                ++count;
            }
            return count < quantity;
        };
        return atLeast;
    }

    private boolean masterDeclaracaoRegularidade(SInstance ins) {
        return !ins.findNearest((SType)this.enviarDeclaracaoReg).filter(p -> Boolean.TRUE.equals(p.getValue())).isPresent();
    }
}

