/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.telemetry;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.telemetry.metrics.Histogram;
import org.opensearch.telemetry.metrics.tags.Tags;

public class TestInMemoryHistogram
implements Histogram {
    private AtomicInteger histogramValue = new AtomicInteger(0);
    private ConcurrentHashMap<HashMap<String, ?>, Double> histogramValueForTags = new ConcurrentHashMap();

    public Integer getHistogramValue() {
        return this.histogramValue.get();
    }

    public ConcurrentHashMap<HashMap<String, ?>, Double> getHistogramValueForTags() {
        return this.histogramValueForTags;
    }

    public void record(double value) {
        this.histogramValue.addAndGet((int)value);
    }

    public synchronized void record(double value, Tags tags) {
        HashMap hashMap = (HashMap)tags.getTagsMap();
        this.histogramValueForTags.put(hashMap, value);
    }
}

