/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.telemetry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.telemetry.metrics.Counter;
import org.opensearch.telemetry.metrics.tags.Tags;

public class TestInMemoryCounter
implements Counter {
    private AtomicInteger counterValue = new AtomicInteger(0);
    private final ConcurrentHashMap<Map<String, ?>, Double> counterValueForTags = new ConcurrentHashMap();

    public Integer getCounterValue() {
        return this.counterValue.get();
    }

    public ConcurrentHashMap<Map<String, ?>, Double> getCounterValueForTags() {
        return this.counterValueForTags;
    }

    public void add(double value) {
        this.counterValue.addAndGet((int)value);
    }

    public synchronized void add(double value, Tags tags) {
        Map tagsMap = tags.getTagsMap();
        if (this.counterValueForTags.get(tagsMap) == null) {
            this.counterValueForTags.put(tagsMap, value);
        } else {
            value = this.counterValueForTags.get(tagsMap) + value;
            this.counterValueForTags.put(tagsMap, value);
        }
    }
}

