/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.telemetry.tracing.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.telemetry.tracing.attributes.Attributes;
import org.opensearch.test.telemetry.tracing.MockSpanData;
import org.opensearch.test.telemetry.tracing.TracingValidator;

public class NumberOfTraceIDsEqualToRequests
implements TracingValidator {
    private static final String FILTERING_ATTRIBUTE = "action";
    private final Attributes attributes;

    public NumberOfTraceIDsEqualToRequests(Attributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public List<MockSpanData> validate(List<MockSpanData> spans, int requests) {
        Set totalTraceIDs = spans.stream().filter(span -> this.isMatchingSpan((MockSpanData)span)).map(MockSpanData::getTraceID).collect(Collectors.toSet());
        ArrayList<MockSpanData> problematicSpans = new ArrayList<MockSpanData>();
        if (totalTraceIDs.size() != requests) {
            problematicSpans.addAll(spans);
        }
        return problematicSpans;
    }

    private boolean isMatchingSpan(MockSpanData mockSpanData) {
        if (this.attributes.getAttributesMap().isEmpty()) {
            return true;
        }
        return Objects.equals(mockSpanData.getAttributes().get(FILTERING_ATTRIBUTE), this.attributes.getAttributesMap().get(FILTERING_ATTRIBUTE));
    }
}

