/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.telemetry.tracing;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.opensearch.core.common.Strings;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.SpanKind;
import org.opensearch.telemetry.tracing.TracingContextPropagator;
import org.opensearch.telemetry.tracing.attributes.Attributes;
import org.opensearch.test.telemetry.tracing.MockSpan;
import org.opensearch.test.telemetry.tracing.SpanProcessor;

public class MockTracingContextPropagator
implements TracingContextPropagator {
    private static final String TRACE_PARENT = "traceparent";
    private static final String SEPARATOR = "~";
    private final SpanProcessor spanProcessor;

    public MockTracingContextPropagator(SpanProcessor spanProcessor) {
        this.spanProcessor = spanProcessor;
    }

    public Optional<Span> extract(Map<String, String> props) {
        String value = props.get(TRACE_PARENT);
        if (value != null) {
            String[] values = value.split(SEPARATOR);
            String traceId = values[0];
            String spanId = values[1];
            return Optional.of(new MockSpan(null, null, traceId, spanId, this.spanProcessor, Attributes.EMPTY, SpanKind.INTERNAL));
        }
        return Optional.empty();
    }

    public Optional<Span> extractFromHeaders(Map<String, List<String>> headers) {
        if (headers != null) {
            Map<String, String> convertedHeader = headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Strings.collectionToCommaDelimitedString((Iterable)((Iterable)e.getValue()))));
            return this.extract(convertedHeader);
        }
        return Optional.empty();
    }

    public void inject(Span currentSpan, BiConsumer<String, String> setter) {
        if (currentSpan instanceof MockSpan) {
            String traceId = currentSpan.getTraceId();
            String spanId = currentSpan.getSpanId();
            String traceParent = String.format(Locale.ROOT, "%s%s%s", traceId, SEPARATOR, spanId);
            setter.accept(TRACE_PARENT, traceParent);
        }
    }
}

