/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.telemetry.tracing;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.opensearch.telemetry.tracing.AbstractSpan;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.attributes.Attributes;
import org.opensearch.test.telemetry.tracing.SpanProcessor;

public class MockSpan
extends AbstractSpan {
    private final SpanProcessor spanProcessor;
    private final Map<String, Object> metadata;
    private final String traceId;
    private final String spanId;
    private boolean hasEnded;
    private final Long startTime;
    private Long endTime;
    private final Object lock = new Object();
    private static final Supplier<Random> randomSupplier = ThreadLocalRandom::current;

    public MockSpan(String spanName, Span parentSpan, SpanProcessor spanProcessor, Attributes attributes) {
        this(spanName, parentSpan, parentSpan != null ? parentSpan.getTraceId() : IdGenerator.generateTraceId(), IdGenerator.generateSpanId(), spanProcessor, attributes);
    }

    public MockSpan(String spanName, Span parentSpan, SpanProcessor spanProcessor) {
        this(spanName, parentSpan, parentSpan != null ? parentSpan.getTraceId() : IdGenerator.generateTraceId(), IdGenerator.generateSpanId(), spanProcessor, Attributes.EMPTY);
    }

    public MockSpan(String spanName, Span parentSpan, String traceId, String spanId, SpanProcessor spanProcessor, Attributes attributes) {
        super(spanName, parentSpan);
        this.spanProcessor = spanProcessor;
        this.metadata = new HashMap<String, Object>();
        this.traceId = traceId;
        this.spanId = spanId;
        this.startTime = System.nanoTime();
        if (attributes != null) {
            this.metadata.putAll(attributes.getAttributesMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSpan() {
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                return;
            }
            this.endTime = System.nanoTime();
            this.hasEnded = true;
        }
        this.spanProcessor.onEnd((Span)this);
    }

    public void addAttribute(String key, String value) {
        this.putMetadata(key, value);
    }

    public void addAttribute(String key, Long value) {
        this.putMetadata(key, value);
    }

    public void addAttribute(String key, Double value) {
        this.putMetadata(key, value);
    }

    public void addAttribute(String key, Boolean value) {
        this.putMetadata(key, value);
    }

    public void addEvent(String event) {
        this.putMetadata(event, null);
    }

    private void putMetadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEnded() {
        Object object = this.lock;
        synchronized (object) {
            return this.hasEnded;
        }
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setError(Exception exception) {
        this.putMetadata("ERROR", exception.getMessage());
    }

    public Object getAttribute(String key) {
        return this.metadata.get(key);
    }

    private static class IdGenerator {
        private IdGenerator() {
        }

        private static String generateSpanId() {
            long id = randomSupplier.get().nextLong();
            return Long.toHexString(id);
        }

        private static String generateTraceId() {
            long idHi = randomSupplier.get().nextLong();
            long idLo = randomSupplier.get().nextLong();
            long result = idLo | idHi << 32;
            return Long.toHexString(result);
        }
    }
}

