/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.transport;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.Version;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.lifecycle.Lifecycle;
import org.opensearch.common.lifecycle.LifecycleListener;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.transport.BoundTransportAddress;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.tasks.Task;
import org.opensearch.transport.ConnectionProfile;
import org.opensearch.transport.RequestHandlerRegistry;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportMessageListener;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportStats;

public class StubbableTransport
implements Transport {
    private final ConcurrentHashMap<TransportAddress, SendRequestBehavior> sendBehaviors = new ConcurrentHashMap();
    private final ConcurrentHashMap<TransportAddress, OpenConnectionBehavior> connectBehaviors = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, RequestHandlerRegistry<?>> replacedRequestRegistries = new ConcurrentHashMap();
    private volatile SendRequestBehavior defaultSendRequest = null;
    private volatile OpenConnectionBehavior defaultConnectBehavior = null;
    private final Transport delegate;

    public StubbableTransport(Transport transport) {
        this.delegate = transport;
    }

    boolean setDefaultSendBehavior(SendRequestBehavior sendBehavior) {
        SendRequestBehavior prior = this.defaultSendRequest;
        this.defaultSendRequest = sendBehavior;
        return prior == null;
    }

    public boolean setDefaultConnectBehavior(OpenConnectionBehavior openConnectionBehavior) {
        OpenConnectionBehavior prior = this.defaultConnectBehavior;
        this.defaultConnectBehavior = openConnectionBehavior;
        return prior == null;
    }

    boolean addSendBehavior(TransportAddress transportAddress, SendRequestBehavior sendBehavior) {
        return this.sendBehaviors.put(transportAddress, sendBehavior) == null;
    }

    boolean addConnectBehavior(TransportAddress transportAddress, OpenConnectionBehavior connectBehavior) {
        return this.connectBehaviors.put(transportAddress, connectBehavior) == null;
    }

    <Request extends TransportRequest> void addRequestHandlingBehavior(String actionName, RequestHandlingBehavior<Request> behavior) {
        Transport.RequestHandlers requestHandlers = this.delegate.getRequestHandlers();
        RequestHandlerRegistry realRegistry = requestHandlers.getHandler(actionName);
        if (realRegistry == null) {
            throw new IllegalStateException("Cannot find registered action for: " + actionName);
        }
        this.replacedRequestRegistries.put(actionName, realRegistry);
        TransportRequestHandler realHandler = realRegistry.getHandler();
        RequestHandlerRegistry newRegistry = RequestHandlerRegistry.replaceHandler((RequestHandlerRegistry)realRegistry, (request, channel, task) -> behavior.messageReceived(realHandler, request, channel, task));
        requestHandlers.forceRegister(newRegistry);
    }

    void clearBehaviors() {
        this.clearOutboundBehaviors();
        this.clearInboundBehaviors();
    }

    void clearInboundBehaviors() {
        for (Map.Entry<String, RequestHandlerRegistry<?>> entry : this.replacedRequestRegistries.entrySet()) {
            this.getRequestHandlers().forceRegister(entry.getValue());
        }
        this.replacedRequestRegistries.clear();
    }

    void clearOutboundBehaviors() {
        this.defaultSendRequest = null;
        this.sendBehaviors.clear();
        this.defaultConnectBehavior = null;
        this.connectBehaviors.clear();
    }

    void clearOutboundBehaviors(TransportAddress transportAddress) {
        OpenConnectionBehavior openConnectionBehavior;
        SendRequestBehavior behavior = this.sendBehaviors.remove(transportAddress);
        if (behavior != null) {
            behavior.clearCallback();
        }
        if ((openConnectionBehavior = this.connectBehaviors.remove(transportAddress)) != null) {
            openConnectionBehavior.clearCallback();
        }
    }

    Transport getDelegate() {
        return this.delegate;
    }

    public void setMessageListener(TransportMessageListener listener) {
        this.delegate.setMessageListener(listener);
    }

    public BoundTransportAddress boundAddress() {
        return this.delegate.boundAddress();
    }

    public TransportAddress[] addressesFromString(String address) throws UnknownHostException {
        return this.delegate.addressesFromString(address);
    }

    public List<String> getDefaultSeedAddresses() {
        return this.delegate.getDefaultSeedAddresses();
    }

    public void openConnection(DiscoveryNode node, ConnectionProfile profile, ActionListener<Transport.Connection> listener) {
        TransportAddress address = node.getAddress();
        OpenConnectionBehavior behavior = this.connectBehaviors.getOrDefault(address, this.defaultConnectBehavior);
        ActionListener wrappedListener = ActionListener.delegateFailure(listener, (delegatedListener, connection) -> delegatedListener.onResponse((Object)new WrappedConnection((Transport.Connection)connection)));
        if (behavior == null) {
            this.delegate.openConnection(node, profile, wrappedListener);
        } else {
            behavior.openConnection(this.delegate, node, profile, (ActionListener<Transport.Connection>)wrappedListener);
        }
    }

    public TransportStats getStats() {
        return this.delegate.getStats();
    }

    public Transport.ResponseHandlers getResponseHandlers() {
        return this.delegate.getResponseHandlers();
    }

    public Transport.RequestHandlers getRequestHandlers() {
        return this.delegate.getRequestHandlers();
    }

    public Lifecycle.State lifecycleState() {
        return this.delegate.lifecycleState();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.delegate.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.delegate.removeLifecycleListener(listener);
    }

    public void start() {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    public void close() {
        this.delegate.close();
    }

    public Map<String, BoundTransportAddress> profileBoundAddresses() {
        return this.delegate.profileBoundAddresses();
    }

    @FunctionalInterface
    public static interface SendRequestBehavior {
        public void sendRequest(Transport.Connection var1, long var2, String var4, TransportRequest var5, TransportRequestOptions var6) throws IOException;

        default public void clearCallback() {
        }
    }

    @FunctionalInterface
    public static interface OpenConnectionBehavior {
        public void openConnection(Transport var1, DiscoveryNode var2, ConnectionProfile var3, ActionListener<Transport.Connection> var4);

        default public void clearCallback() {
        }
    }

    @FunctionalInterface
    public static interface RequestHandlingBehavior<Request extends TransportRequest> {
        public void messageReceived(TransportRequestHandler<Request> var1, Request var2, TransportChannel var3, Task var4) throws Exception;

        default public void clearCallback() {
        }
    }

    public class WrappedConnection
    implements Transport.Connection {
        private final Transport.Connection connection;

        private WrappedConnection(Transport.Connection connection) {
            this.connection = connection;
        }

        public DiscoveryNode getNode() {
            return this.connection.getNode();
        }

        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            TransportAddress address = this.connection.getNode().getAddress();
            SendRequestBehavior behavior = StubbableTransport.this.sendBehaviors.getOrDefault(address, StubbableTransport.this.defaultSendRequest);
            if (behavior == null) {
                this.connection.sendRequest(requestId, action, request, options);
            } else {
                behavior.sendRequest(this.connection, requestId, action, request, options);
            }
        }

        public void addCloseListener(ActionListener<Void> listener) {
            this.connection.addCloseListener(listener);
        }

        public boolean isClosed() {
            return this.connection.isClosed();
        }

        public Version getVersion() {
            return this.connection.getVersion();
        }

        public Object getCacheKey() {
            return this.connection.getCacheKey();
        }

        public void close() {
            this.connection.close();
        }

        public Transport.Connection getConnection() {
            return this.connection;
        }
    }
}

