/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest.yaml;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.opensearch.Version;
import org.opensearch.client.NodeSelector;
import org.opensearch.client.Request;
import org.opensearch.client.Response;
import org.opensearch.client.ResponseException;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.test.rest.yaml.ClientYamlTestClient;
import org.opensearch.test.rest.yaml.ClientYamlTestResponse;
import org.opensearch.test.rest.yaml.ClientYamlTestResponseException;
import org.opensearch.test.rest.yaml.restspec.ClientYamlSuiteRestSpec;

public final class ClientYamlDocsTestClient
extends ClientYamlTestClient {
    public ClientYamlDocsTestClient(ClientYamlSuiteRestSpec restSpec, RestClient restClient, List<HttpHost> hosts, Version esVersion, Version clusterManagerVersion, CheckedSupplier<RestClientBuilder, IOException> clientBuilderWithSniffedNodes) {
        super(restSpec, restClient, hosts, esVersion, clusterManagerVersion, clientBuilderWithSniffedNodes);
    }

    @Override
    public ClientYamlTestResponse callApi(String apiName, Map<String, String> params, HttpEntity entity, Map<String, String> headers, NodeSelector nodeSelector) throws IOException {
        if ("raw".equals(apiName)) {
            HashMap<String, String> queryStringParams = new HashMap<String, String>(params);
            String method = Objects.requireNonNull((String)queryStringParams.remove("method"), "Method must be set to use raw request");
            String path = "/" + Objects.requireNonNull((String)queryStringParams.remove("path"), "Path must be set to use raw request");
            Request request = new Request(method, path);
            for (Map.Entry param : queryStringParams.entrySet()) {
                request.addParameter((String)param.getKey(), (String)param.getValue());
            }
            request.setEntity(entity);
            ClientYamlDocsTestClient.setOptions(request, headers);
            try {
                Response response = this.getRestClient(nodeSelector).performRequest(request);
                return new ClientYamlTestResponse(response);
            }
            catch (ResponseException e) {
                throw new ClientYamlTestResponseException(e);
            }
        }
        return super.callApi(apiName, params, entity, headers, nodeSelector);
    }
}

