/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.gateway;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.RerouteService;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.common.util.BatchRunnableExecutor;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.gateway.PrimaryShardBatchAllocator;
import org.opensearch.gateway.ReplicaShardBatchAllocator;
import org.opensearch.gateway.ShardsBatchGatewayAllocator;
import org.opensearch.gateway.TransportNodesGatewayStartedShardHelper;
import org.opensearch.gateway.TransportNodesListGatewayStartedShardsBatch;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.store.TransportNodesListShardStoreMetadataBatch;

public class TestShardBatchGatewayAllocator
extends ShardsBatchGatewayAllocator {
    CountDownLatch latch;
    Map<String, Map<ShardId, ShardRouting>> knownAllocations = new HashMap<String, Map<ShardId, ShardRouting>>();
    DiscoveryNodes currentNodes = DiscoveryNodes.EMPTY_NODES;
    Map<String, ReplicationCheckpoint> shardIdNodeToReplicationCheckPointMap = new HashMap<String, ReplicationCheckpoint>();
    PrimaryShardBatchAllocator primaryBatchShardAllocator = new PrimaryShardBatchAllocator(){

        protected AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch> fetchData(List<ShardRouting> eligibleShards, List<ShardRouting> inEligibleShards, RoutingAllocation allocation) {
            HashMap<DiscoveryNode, TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch> foundShards = new HashMap<DiscoveryNode, TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch>();
            HashMap<ShardId, Set> shardsToIgnoreNodes = new HashMap<ShardId, Set>();
            for (Map.Entry<String, Map<ShardId, ShardRouting>> entry : TestShardBatchGatewayAllocator.this.knownAllocations.entrySet()) {
                String nodeId = entry.getKey();
                Map<ShardId, ShardRouting> shardsOnNode = entry.getValue();
                HashMap<ShardId, TransportNodesGatewayStartedShardHelper.GatewayStartedShard> adaptedResponse = new HashMap<ShardId, TransportNodesGatewayStartedShardHelper.GatewayStartedShard>();
                for (ShardRouting shardRouting : eligibleShards) {
                    ShardId shardId = shardRouting.shardId();
                    Set ignoreNodes = allocation.getIgnoreNodes(shardId);
                    if (shardsOnNode.containsKey(shardId) && !ignoreNodes.contains(nodeId) && TestShardBatchGatewayAllocator.this.currentNodes.nodeExists(nodeId)) {
                        TransportNodesGatewayStartedShardHelper.GatewayStartedShard nodeShard = new TransportNodesGatewayStartedShardHelper.GatewayStartedShard(shardsOnNode.get(shardId).allocationId().getId(), shardsOnNode.get(shardId).primary(), TestShardBatchGatewayAllocator.this.getReplicationCheckpoint(shardId, nodeId));
                        adaptedResponse.put(shardId, nodeShard);
                        shardsToIgnoreNodes.put(shardId, ignoreNodes);
                    }
                    foundShards.put(TestShardBatchGatewayAllocator.this.currentNodes.get(nodeId), new TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch(TestShardBatchGatewayAllocator.this.currentNodes.get(nodeId), adaptedResponse));
                }
            }
            return new AsyncShardFetch.FetchResult(foundShards, shardsToIgnoreNodes);
        }

        protected void allocateUnassignedBatchOnTimeout(Set<ShardId> shardIds, RoutingAllocation allocation, boolean primary) {
            for (int i = 0; i < shardIds.size(); ++i) {
                TestShardBatchGatewayAllocator.this.latch.countDown();
            }
        }
    };
    ReplicaShardBatchAllocator replicaBatchShardAllocator = new ReplicaShardBatchAllocator(){

        protected AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadataBatch> fetchData(List<ShardRouting> eligibleShards, List<ShardRouting> inEligibleShards, RoutingAllocation allocation) {
            return new AsyncShardFetch.FetchResult(Collections.emptyMap(), Collections.emptyMap());
        }

        protected boolean hasInitiatedFetching(ShardRouting shard) {
            return true;
        }

        protected void allocateUnassignedBatchOnTimeout(Set<ShardId> shardIds, RoutingAllocation allocation, boolean primary) {
            for (int i = 0; i < shardIds.size(); ++i) {
                TestShardBatchGatewayAllocator.this.latch.countDown();
            }
        }
    };

    public TestShardBatchGatewayAllocator() {
    }

    public TestShardBatchGatewayAllocator(CountDownLatch latch, long maxBatchSize, RerouteService rerouteService) {
        super(maxBatchSize, rerouteService);
        this.latch = latch;
    }

    public TestShardBatchGatewayAllocator(long maxBatchSize) {
        super(maxBatchSize, null);
    }

    public BatchRunnableExecutor allocateAllUnassignedShards(RoutingAllocation allocation, boolean primary) {
        this.currentNodes = allocation.nodes();
        return this.innerAllocateUnassignedBatch(allocation, this.primaryBatchShardAllocator, this.replicaBatchShardAllocator, primary);
    }

    public void beforeAllocation(RoutingAllocation allocation) {
    }

    public void afterPrimariesBeforeReplicas(RoutingAllocation allocation) {
    }

    public Set<String> createAndUpdateBatches(RoutingAllocation allocation, boolean primary) {
        return super.createAndUpdateBatches(allocation, primary);
    }

    public void safelyRemoveShardFromBatch(ShardRouting shard) {
        super.safelyRemoveShardFromBatch(shard, shard.primary());
    }

    public void safelyRemoveShardFromBothBatch(ShardRouting shardRouting) {
        super.safelyRemoveShardFromBothBatch(shardRouting);
    }

    public String getBatchId(ShardRouting shard, boolean primary) {
        return super.getBatchId(shard, primary);
    }

    public Map<String, ShardsBatchGatewayAllocator.ShardsBatch> getBatchIdToStartedShardBatch() {
        return this.batchIdToStartedShardBatch;
    }

    public Map<String, ShardsBatchGatewayAllocator.ShardsBatch> getBatchIdToStoreShardBatch() {
        return this.batchIdToStoreShardBatch;
    }

    public AllocateUnassignedDecision explainUnassignedShardAllocation(ShardRouting unassignedShard, RoutingAllocation routingAllocation) {
        return super.explainUnassignedShardAllocation(unassignedShard, routingAllocation);
    }

    protected ReplicationCheckpoint getReplicationCheckpoint(ShardId shardId, String nodeName) {
        return this.shardIdNodeToReplicationCheckPointMap.getOrDefault(this.getReplicationCheckPointKey(shardId, nodeName), null);
    }

    public String getReplicationCheckPointKey(ShardId shardId, String nodeName) {
        return shardId.toString() + "_" + nodeName;
    }
}

