/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.disruption;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.util.Throwables;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateTaskConfig;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Priority;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.test.InternalTestCluster;
import org.opensearch.test.disruption.SingleNodeDisruption;

public class BlockClusterManagerServiceOnClusterManager
extends SingleNodeDisruption {
    AtomicReference<CountDownLatch> disruptionLatch = new AtomicReference();

    public BlockClusterManagerServiceOnClusterManager(Random random) {
        super(random);
    }

    @Override
    public void startDisrupting() {
        this.disruptedNode = this.cluster.getClusterManagerName();
        String disruptionNodeCopy = this.disruptedNode;
        if (disruptionNodeCopy == null) {
            return;
        }
        ClusterService clusterService = this.cluster.getInstance(ClusterService.class, disruptionNodeCopy);
        if (clusterService == null) {
            return;
        }
        this.logger.info("blocking cluster-manager service on node [{}]", (Object)disruptionNodeCopy);
        boolean success = this.disruptionLatch.compareAndSet(null, new CountDownLatch(1));
        assert (success) : "startDisrupting called without waiting on stopDisrupting to complete";
        final CountDownLatch started = new CountDownLatch(1);
        clusterService.getClusterManagerService().submitStateUpdateTask("service_disruption_block", (ClusterStateTaskConfig)new ClusterStateUpdateTask(this){
            final /* synthetic */ BlockClusterManagerServiceOnClusterManager this$0;
            {
                this.this$0 = this$0;
            }

            public Priority priority() {
                return Priority.IMMEDIATE;
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                started.countDown();
                CountDownLatch latch = this.this$0.disruptionLatch.get();
                if (latch != null) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        Throwables.rethrow((Throwable)e);
                    }
                }
                return currentState;
            }

            public void onFailure(String source, Exception e) {
                this.this$0.logger.error("unexpected error during disruption", (Throwable)e);
            }
        });
        try {
            started.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void stopDisrupting() {
        CountDownLatch latch = this.disruptionLatch.get();
        if (latch != null) {
            latch.countDown();
        }
    }

    @Override
    public void removeAndEnsureHealthy(InternalTestCluster cluster) {
        this.removeFromCluster(cluster);
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return TimeValue.timeValueMinutes((long)0L);
    }
}

