/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.core.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.apache.lucene.tests.util.LineFileDocs;
import org.apache.lucene.tests.util.TestUtil;
import org.opensearch.core.compress.Compressor;
import org.opensearch.test.OpenSearchTestCase;

public abstract class AbstractCompressorTestCase
extends OpenSearchTestCase {
    public void testRandom() throws IOException {
        Random r = AbstractCompressorTestCase.random();
        for (int i = 0; i < 10; ++i) {
            byte[] bytes = new byte[TestUtil.nextInt((Random)r, (int)1, (int)100000)];
            r.nextBytes(bytes);
            this.doTest(bytes);
        }
    }

    public void testRandomThreads() throws Exception {
        Random r = AbstractCompressorTestCase.random();
        int threadCount = TestUtil.nextInt((Random)r, (int)2, (int)6);
        Thread[] threads = new Thread[threadCount];
        final CountDownLatch startingGun = new CountDownLatch(1);
        for (int tid = 0; tid < threadCount; ++tid) {
            final long seed = r.nextLong();
            threads[tid] = new Thread(this){
                final /* synthetic */ AbstractCompressorTestCase this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        Random r = new Random(seed);
                        startingGun.await();
                        for (int i = 0; i < 10; ++i) {
                            byte[] bytes = new byte[TestUtil.nextInt((Random)r, (int)1, (int)100000)];
                            r.nextBytes(bytes);
                            this.this$0.doTest(bytes);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            threads[tid].start();
        }
        startingGun.countDown();
        for (Thread t : threads) {
            t.join();
        }
    }

    public void testLineDocs() throws IOException {
        Random r = AbstractCompressorTestCase.random();
        LineFileDocs lineFileDocs = new LineFileDocs(r);
        for (int i = 0; i < 10; ++i) {
            int numDocs = TestUtil.nextInt((Random)r, (int)1, (int)200);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            for (int j = 0; j < numDocs; ++j) {
                String s = lineFileDocs.nextDoc().get("body");
                bos.write(s.getBytes(StandardCharsets.UTF_8));
            }
            this.doTest(bos.toByteArray());
        }
        lineFileDocs.close();
    }

    public void testLineDocsThreads() throws Exception {
        Random r = AbstractCompressorTestCase.random();
        int threadCount = TestUtil.nextInt((Random)r, (int)2, (int)6);
        Thread[] threads = new Thread[threadCount];
        final CountDownLatch startingGun = new CountDownLatch(1);
        for (int tid = 0; tid < threadCount; ++tid) {
            final long seed = r.nextLong();
            threads[tid] = new Thread(this){
                final /* synthetic */ AbstractCompressorTestCase this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        Random r = new Random(seed);
                        startingGun.await();
                        LineFileDocs lineFileDocs = new LineFileDocs(r);
                        for (int i = 0; i < 10; ++i) {
                            int numDocs = TestUtil.nextInt((Random)r, (int)1, (int)200);
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            for (int j = 0; j < numDocs; ++j) {
                                String s = lineFileDocs.nextDoc().get("body");
                                bos.write(s.getBytes(StandardCharsets.UTF_8));
                            }
                            this.this$0.doTest(bos.toByteArray());
                        }
                        lineFileDocs.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            threads[tid].start();
        }
        startingGun.countDown();
        for (Thread t : threads) {
            t.join();
        }
    }

    public void testRepetitionsL() throws IOException {
        Random r = AbstractCompressorTestCase.random();
        for (int i = 0; i < 10; ++i) {
            int numLongs = TestUtil.nextInt((Random)r, (int)1, (int)10000);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            long theValue = r.nextLong();
            for (int j = 0; j < numLongs; ++j) {
                if (r.nextInt(10) == 0) {
                    theValue = r.nextLong();
                }
                bos.write((byte)(theValue >>> 56));
                bos.write((byte)(theValue >>> 48));
                bos.write((byte)(theValue >>> 40));
                bos.write((byte)(theValue >>> 32));
                bos.write((byte)(theValue >>> 24));
                bos.write((byte)(theValue >>> 16));
                bos.write((byte)(theValue >>> 8));
                bos.write((byte)theValue);
            }
            this.doTest(bos.toByteArray());
        }
    }

    public void testRepetitionsLThreads() throws Exception {
        Random r = AbstractCompressorTestCase.random();
        int threadCount = TestUtil.nextInt((Random)r, (int)2, (int)6);
        Thread[] threads = new Thread[threadCount];
        final CountDownLatch startingGun = new CountDownLatch(1);
        for (int tid = 0; tid < threadCount; ++tid) {
            final long seed = r.nextLong();
            threads[tid] = new Thread(this){
                final /* synthetic */ AbstractCompressorTestCase this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        Random r = new Random(seed);
                        startingGun.await();
                        for (int i = 0; i < 10; ++i) {
                            int numLongs = TestUtil.nextInt((Random)r, (int)1, (int)10000);
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            long theValue = r.nextLong();
                            for (int j = 0; j < numLongs; ++j) {
                                if (r.nextInt(10) == 0) {
                                    theValue = r.nextLong();
                                }
                                bos.write((byte)(theValue >>> 56));
                                bos.write((byte)(theValue >>> 48));
                                bos.write((byte)(theValue >>> 40));
                                bos.write((byte)(theValue >>> 32));
                                bos.write((byte)(theValue >>> 24));
                                bos.write((byte)(theValue >>> 16));
                                bos.write((byte)(theValue >>> 8));
                                bos.write((byte)theValue);
                            }
                            this.this$0.doTest(bos.toByteArray());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            threads[tid].start();
        }
        startingGun.countDown();
        for (Thread t : threads) {
            t.join();
        }
    }

    public void testRepetitionsI() throws IOException {
        Random r = AbstractCompressorTestCase.random();
        for (int i = 0; i < 10; ++i) {
            int numInts = TestUtil.nextInt((Random)r, (int)1, (int)20000);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int theValue = r.nextInt();
            for (int j = 0; j < numInts; ++j) {
                if (r.nextInt(10) == 0) {
                    theValue = r.nextInt();
                }
                bos.write((byte)(theValue >>> 24));
                bos.write((byte)(theValue >>> 16));
                bos.write((byte)(theValue >>> 8));
                bos.write((byte)theValue);
            }
            this.doTest(bos.toByteArray());
        }
    }

    public void testRepetitionsIThreads() throws Exception {
        Random r = AbstractCompressorTestCase.random();
        int threadCount = TestUtil.nextInt((Random)r, (int)2, (int)6);
        Thread[] threads = new Thread[threadCount];
        final CountDownLatch startingGun = new CountDownLatch(1);
        for (int tid = 0; tid < threadCount; ++tid) {
            final long seed = r.nextLong();
            threads[tid] = new Thread(this){
                final /* synthetic */ AbstractCompressorTestCase this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        Random r = new Random(seed);
                        startingGun.await();
                        for (int i = 0; i < 10; ++i) {
                            int numInts = TestUtil.nextInt((Random)r, (int)1, (int)20000);
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            int theValue = r.nextInt();
                            for (int j = 0; j < numInts; ++j) {
                                if (r.nextInt(10) == 0) {
                                    theValue = r.nextInt();
                                }
                                bos.write((byte)(theValue >>> 24));
                                bos.write((byte)(theValue >>> 16));
                                bos.write((byte)(theValue >>> 8));
                                bos.write((byte)theValue);
                            }
                            this.this$0.doTest(bos.toByteArray());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            threads[tid].start();
        }
        startingGun.countDown();
        for (Thread t : threads) {
            t.join();
        }
    }

    public void testRepetitionsS() throws IOException {
        Random r = AbstractCompressorTestCase.random();
        for (int i = 0; i < 10; ++i) {
            int numShorts = TestUtil.nextInt((Random)r, (int)1, (int)40000);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            short theValue = (short)r.nextInt(65535);
            for (int j = 0; j < numShorts; ++j) {
                if (r.nextInt(10) == 0) {
                    theValue = (short)r.nextInt(65535);
                }
                bos.write((byte)(theValue >>> 8));
                bos.write((byte)theValue);
            }
            this.doTest(bos.toByteArray());
        }
    }

    public void testMixed() throws IOException {
        Random r = AbstractCompressorTestCase.random();
        LineFileDocs lineFileDocs = new LineFileDocs(r);
        for (int i = 0; i < 2; ++i) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int prevInt = r.nextInt();
            long prevLong = r.nextLong();
            block7: while (bos.size() < 400000) {
                switch (r.nextInt(4)) {
                    case 0: {
                        this.addInt(r, prevInt, bos);
                        continue block7;
                    }
                    case 1: {
                        this.addLong(r, prevLong, bos);
                        continue block7;
                    }
                    case 2: {
                        this.addString(lineFileDocs, bos);
                        continue block7;
                    }
                    case 3: {
                        this.addBytes(r, bos);
                        continue block7;
                    }
                }
                throw new IllegalStateException("Random is broken");
            }
            this.doTest(bos.toByteArray());
        }
    }

    private void addLong(Random r, long prev, ByteArrayOutputStream bos) {
        long theValue = prev;
        if (r.nextInt(10) != 0) {
            theValue = r.nextLong();
        }
        bos.write((byte)(theValue >>> 56));
        bos.write((byte)(theValue >>> 48));
        bos.write((byte)(theValue >>> 40));
        bos.write((byte)(theValue >>> 32));
        bos.write((byte)(theValue >>> 24));
        bos.write((byte)(theValue >>> 16));
        bos.write((byte)(theValue >>> 8));
        bos.write((byte)theValue);
    }

    private void addInt(Random r, int prev, ByteArrayOutputStream bos) {
        int theValue = prev;
        if (r.nextInt(10) != 0) {
            theValue = r.nextInt();
        }
        bos.write((byte)(theValue >>> 24));
        bos.write((byte)(theValue >>> 16));
        bos.write((byte)(theValue >>> 8));
        bos.write((byte)theValue);
    }

    private void addString(LineFileDocs lineFileDocs, ByteArrayOutputStream bos) throws IOException {
        String s = lineFileDocs.nextDoc().get("body");
        bos.write(s.getBytes(StandardCharsets.UTF_8));
    }

    private void addBytes(Random r, ByteArrayOutputStream bos) throws IOException {
        byte[] bytes = new byte[TestUtil.nextInt((Random)r, (int)1, (int)10000)];
        r.nextBytes(bytes);
        bos.write(bytes);
    }

    public void testRepetitionsSThreads() throws Exception {
        Random r = AbstractCompressorTestCase.random();
        int threadCount = TestUtil.nextInt((Random)r, (int)2, (int)6);
        Thread[] threads = new Thread[threadCount];
        final CountDownLatch startingGun = new CountDownLatch(1);
        for (int tid = 0; tid < threadCount; ++tid) {
            final long seed = r.nextLong();
            threads[tid] = new Thread(this){
                final /* synthetic */ AbstractCompressorTestCase this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        Random r = new Random(seed);
                        startingGun.await();
                        for (int i = 0; i < 10; ++i) {
                            int numShorts = TestUtil.nextInt((Random)r, (int)1, (int)40000);
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            short theValue = (short)r.nextInt(65535);
                            for (int j = 0; j < numShorts; ++j) {
                                if (r.nextInt(10) == 0) {
                                    theValue = (short)r.nextInt(65535);
                                }
                                bos.write((byte)(theValue >>> 8));
                                bos.write((byte)theValue);
                            }
                            this.this$0.doTest(bos.toByteArray());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            threads[tid].start();
        }
        startingGun.countDown();
        for (Thread t : threads) {
            t.join();
        }
    }

    private void doTest(byte[] bytes) throws IOException {
        int len;
        ByteArrayInputStream rawIn = new ByteArrayInputStream(bytes);
        Compressor c = this.compressor();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Random r = AbstractCompressorTestCase.random();
        int bufferSize = r.nextBoolean() ? 65535 : TestUtil.nextInt((Random)AbstractCompressorTestCase.random(), (int)1, (int)70000);
        int prepadding = r.nextInt(70000);
        int postpadding = r.nextInt(70000);
        byte[] buffer = new byte[prepadding + bufferSize + postpadding];
        try (OutputStream os = c.threadLocalOutputStream((OutputStream)bos);){
            r.nextBytes(buffer);
            while ((len = ((InputStream)rawIn).read(buffer, prepadding, bufferSize)) != -1) {
                os.write(buffer, prepadding, len);
            }
        }
        ((InputStream)rawIn).close();
        InputStream in = c.threadLocalInputStream((InputStream)new ByteArrayInputStream(bos.toByteArray()));
        bufferSize = r.nextBoolean() ? 65535 : TestUtil.nextInt((Random)AbstractCompressorTestCase.random(), (int)1, (int)70000);
        prepadding = r.nextInt(70000);
        postpadding = r.nextInt(70000);
        buffer = new byte[prepadding + bufferSize + postpadding];
        r.nextBytes(buffer);
        ByteArrayOutputStream uncompressedOut = new ByteArrayOutputStream();
        while ((len = in.read(buffer, prepadding, bufferSize)) != -1) {
            uncompressedOut.write(buffer, prepadding, len);
        }
        uncompressedOut.close();
        AbstractCompressorTestCase.assertArrayEquals((byte[])bytes, (byte[])uncompressedOut.toByteArray());
    }

    protected abstract Compressor compressor();
}

