/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.RegexFilter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.regex.Regex;

public class MockLogAppender
extends AbstractAppender
implements AutoCloseable {
    private static final String COMMON_PREFIX = System.getProperty("opensearch.logger.prefix", "org.opensearch.");
    private final List<LoggingExpectation> expectations = new CopyOnWriteArrayList<LoggingExpectation>();
    private final List<Logger> loggers;

    public static MockLogAppender createForLoggers(Logger ... loggers) throws IllegalAccessException {
        String callingClass = Thread.currentThread().getStackTrace()[2].getClassName();
        return MockLogAppender.createForLoggersInternal(callingClass, ".*(\n.*)*", loggers);
    }

    public static MockLogAppender createForLoggers(String filter, Logger ... loggers) throws IllegalAccessException {
        String callingClass = Thread.currentThread().getStackTrace()[2].getClassName();
        return MockLogAppender.createForLoggersInternal(callingClass, filter, loggers);
    }

    private static MockLogAppender createForLoggersInternal(String callingClass, String filter, Logger ... loggers) throws IllegalAccessException {
        MockLogAppender appender = new MockLogAppender(callingClass + "-mock-log-appender", RegexFilter.createFilter((String)filter, (String[])new String[0], (Boolean)false, null, null), Collections.unmodifiableList(Arrays.asList(loggers)));
        appender.start();
        for (Logger logger : loggers) {
            Loggers.addAppender((Logger)logger, (Appender)appender);
        }
        return appender;
    }

    private MockLogAppender(String name, RegexFilter filter, List<Logger> loggers) {
        super(name, (Filter)filter, null, true, Property.EMPTY_ARRAY);
        this.loggers = loggers;
    }

    public void addExpectation(LoggingExpectation expectation) {
        this.expectations.add(expectation);
    }

    public void append(LogEvent event) {
        for (LoggingExpectation expectation : this.expectations) {
            expectation.match(event);
        }
    }

    public void assertAllExpectationsMatched() {
        for (LoggingExpectation expectation : this.expectations) {
            expectation.assertMatched();
        }
    }

    @Override
    public void close() {
        for (Logger logger : this.loggers) {
            Loggers.removeAppender((Logger)logger, (Appender)this);
        }
        super.stop();
    }

    public void stop() {
        throw new UnsupportedOperationException("Use close() to ensure proper clean up ordering");
    }

    private static String getLoggerName(String name) {
        if (name.startsWith("org.opensearch.")) {
            name = name.substring("org.opensearch.".length());
        }
        return COMMON_PREFIX + name;
    }

    public static interface LoggingExpectation {
        public void match(LogEvent var1);

        public void assertMatched();
    }

    public static class PatternSeenWithLoggerPrefixExpectation
    implements LoggingExpectation {
        private final String expectationName;
        private final String loggerPrefix;
        private final Level level;
        private final String messageMatchingRegex;
        private final List<String> loggerMatches = new ArrayList<String>();
        private final AtomicBoolean eventSeen = new AtomicBoolean(false);

        public PatternSeenWithLoggerPrefixExpectation(String expectationName, String loggerPrefix, Level level, String messageMatchingRegex) {
            this.expectationName = expectationName;
            this.loggerPrefix = loggerPrefix;
            this.level = level;
            this.messageMatchingRegex = messageMatchingRegex;
        }

        @Override
        public void match(LogEvent event) {
            if (event.getLevel() == this.level && event.getLoggerName().startsWith(this.loggerPrefix)) {
                String formattedMessage = event.getMessage().getFormattedMessage();
                this.loggerMatches.add(formattedMessage);
                if (formattedMessage.matches(this.messageMatchingRegex)) {
                    this.eventSeen.set(true);
                }
            }
        }

        @Override
        public void assertMatched() {
            if (!this.eventSeen.get()) {
                StringBuilder failureMessage = new StringBuilder();
                failureMessage.append(this.expectationName + " was not seen, found " + this.loggerMatches.size() + " messages matching the logger.");
                failureMessage.append("\r\nMessage matching regex: " + this.messageMatchingRegex);
                if (!this.loggerMatches.isEmpty()) {
                    failureMessage.append("\r\nMessage details:\r\n" + String.join((CharSequence)"\r\n", this.loggerMatches));
                }
                Assert.fail((String)failureMessage.toString());
            }
        }
    }

    public static class PatternSeenEventExpectation
    implements LoggingExpectation {
        protected final String name;
        protected final String logger;
        protected final Level level;
        protected final String pattern;
        volatile boolean saw;

        public PatternSeenEventExpectation(String name, String logger, Level level, String pattern) {
            this.name = name;
            this.logger = logger;
            this.level = level;
            this.pattern = pattern;
        }

        @Override
        public void match(LogEvent event) {
            if (event.getLevel().equals((Object)this.level) && event.getLoggerName().equals(this.logger) && Pattern.matches(this.pattern, event.getMessage().getFormattedMessage())) {
                this.saw = true;
            }
        }

        @Override
        public void assertMatched() {
            MatcherAssert.assertThat((String)this.name, (Object)this.saw, (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    public static class ExceptionSeenEventExpectation
    extends SeenEventExpectation {
        private final Class<? extends Exception> clazz;
        private final String exceptionMessage;

        public ExceptionSeenEventExpectation(String name, String logger, Level level, String message, Class<? extends Exception> clazz, String exceptionMessage) {
            super(name, logger, level, message);
            this.clazz = clazz;
            this.exceptionMessage = exceptionMessage;
        }

        @Override
        public boolean innerMatch(LogEvent event) {
            return event.getThrown() != null && event.getThrown().getClass() == this.clazz && event.getThrown().getMessage().equals(this.exceptionMessage);
        }
    }

    public static class SeenEventExpectation
    extends AbstractEventExpectation {
        public SeenEventExpectation(String name, String logger, Level level, String message) {
            super(name, logger, level, message);
        }

        @Override
        public void assertMatched() {
            MatcherAssert.assertThat((String)("expected to see " + this.name + " but did not"), (Object)this.saw, (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    public static class UnseenEventExpectation
    extends AbstractEventExpectation {
        public UnseenEventExpectation(String name, String logger, Level level, String message) {
            super(name, logger, level, message);
        }

        @Override
        public void assertMatched() {
            MatcherAssert.assertThat((String)("expected not to see " + this.name + " but did"), (Object)this.saw, (Matcher)CoreMatchers.equalTo((Object)false));
        }
    }

    public static abstract class AbstractEventExpectation
    implements LoggingExpectation {
        protected final String name;
        protected final String logger;
        protected final Level level;
        protected final String message;
        volatile boolean saw;

        public AbstractEventExpectation(String name, String logger, Level level, String message) {
            this.name = name;
            this.logger = MockLogAppender.getLoggerName(logger);
            this.level = level;
            this.message = message;
            this.saw = false;
        }

        @Override
        public void match(LogEvent event) {
            if (event.getLevel().equals((Object)this.level) && event.getLoggerName().equals(this.logger) && this.innerMatch(event)) {
                if (Regex.isSimpleMatchPattern((String)this.message)) {
                    if (Regex.simpleMatch((String)this.message, (String)event.getMessage().getFormattedMessage())) {
                        this.saw = true;
                    }
                } else if (event.getMessage().getFormattedMessage().contains(this.message)) {
                    this.saw = true;
                }
            }
        }

        public boolean innerMatch(LogEvent event) {
            return true;
        }
    }
}

