/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Locale;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class KeyStoreUtils {
    public static final char[] KEYSTORE_PASSWORD = "keystore_password".toCharArray();

    public static KeyStore createServerKeyStore() throws Exception {
        X500PrivateCredential serverCred = KeyStoreUtils.createCredential();
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        keyStore.setKeyEntry(serverCred.getAlias(), serverCred.getPrivateKey(), KEYSTORE_PASSWORD, new X509Certificate[]{serverCred.getCertificate()});
        return keyStore;
    }

    private static X500PrivateCredential createCredential() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X509Certificate rootCert = new JcaX509CertificateConverter().getCertificate(KeyStoreUtils.generateCert(keyPair));
        return new X500PrivateCredential(rootCert, keyPair.getPrivate(), "server-ca");
    }

    private static X509CertificateHolder generateCert(KeyPair pair) throws Exception {
        long baseTime = System.currentTimeMillis();
        long validityPeriod = 315360000000L;
        X509v1CertificateBuilder certBuilder = new X509v1CertificateBuilder(X500Name.getInstance((Object)new X500Principal("CN=Test CA Certificate").getEncoded()), BigInteger.valueOf(1L), new Date(baseTime), new Date(baseTime + validityPeriod), Locale.ROOT, X500Name.getInstance((Object)new X500Principal("CN=Test CA Certificate").getEncoded()), SubjectPublicKeyInfo.getInstance((Object)pair.getPublic().getEncoded()));
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(pair.getPrivate());
        return certBuilder.build(signer);
    }
}

