/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.io.IOException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.Assert;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.Diffable;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.core.common.io.stream.NamedWriteableAwareStreamInput;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public final class DiffableTestUtils {
    protected static final int NUMBER_OF_DIFF_TEST_RUNS = 20;

    private DiffableTestUtils() {
    }

    public static <T extends Diffable<T>> T assertDiffApplication(T remoteChanges, T localInstance, Diff<T> diffs) {
        Diffable localChanges = (Diffable)diffs.apply(localInstance);
        Assert.assertEquals(remoteChanges, (Object)localChanges);
        Assert.assertEquals((long)remoteChanges.hashCode(), (long)localChanges.hashCode());
        Assert.assertNotSame(remoteChanges, (Object)localChanges);
        return (T)localChanges;
    }

    public static <T extends Writeable> T copyInstance(T diffs, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader) throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            Writeable writeable;
            diffs.writeTo((StreamOutput)output);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), namedWriteableRegistry);){
                writeable = (Writeable)reader.read((StreamInput)in);
            }
            return (T)writeable;
        }
    }

    public static <T extends Diffable<T>> void testDiffableSerialization(Supplier<T> testInstance, Function<T, T> modifier, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader, Writeable.Reader<Diff<T>> diffReader) throws IOException {
        Diffable remoteInstance = (Diffable)testInstance.get();
        Diffable localInstance = DiffableTestUtils.assertSerialization(remoteInstance, namedWriteableRegistry, reader);
        for (int runs = 0; runs < 20; ++runs) {
            Diffable remoteChanges = (Diffable)modifier.apply(remoteInstance);
            Diff remoteDiffs = remoteChanges.diff((Object)remoteInstance);
            Diff<T> localDiffs = DiffableTestUtils.copyInstance(remoteDiffs, namedWriteableRegistry, diffReader);
            localInstance = DiffableTestUtils.assertDiffApplication(remoteChanges, localInstance, localDiffs);
            remoteInstance = remoteChanges;
        }
    }

    public static <T extends Writeable> T assertSerialization(T testInstance, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader) throws IOException {
        T deserializedInstance = DiffableTestUtils.copyInstance(testInstance, namedWriteableRegistry, reader);
        Assert.assertEquals(testInstance, deserializedInstance);
        Assert.assertEquals((long)testInstance.hashCode(), (long)deserializedInstance.hashCode());
        Assert.assertNotSame(testInstance, deserializedInstance);
        return deserializedInstance;
    }
}

