/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remotestore.multipart.mocks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.CorruptIndexException;
import org.opensearch.common.StreamContext;
import org.opensearch.common.blobstore.AsyncMultiStreamBlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.DeleteResult;
import org.opensearch.common.blobstore.fs.FsBlobContainer;
import org.opensearch.common.blobstore.fs.FsBlobStore;
import org.opensearch.common.blobstore.stream.read.ReadContext;
import org.opensearch.common.blobstore.stream.write.WriteContext;
import org.opensearch.common.io.InputStreamContainer;
import org.opensearch.core.action.ActionListener;

public class MockFsAsyncBlobContainer
extends FsBlobContainer
implements AsyncMultiStreamBlobContainer {
    private static final int TRANSFER_TIMEOUT_MILLIS = 30000;
    private final boolean triggerDataIntegrityFailure;

    public MockFsAsyncBlobContainer(FsBlobStore blobStore, BlobPath blobPath, Path path, boolean triggerDataIntegrityFailure) {
        super(blobStore, blobPath, path);
        this.triggerDataIntegrityFailure = triggerDataIntegrityFailure;
    }

    public void asyncBlobUpload(WriteContext writeContext, ActionListener<Void> completionListener) throws IOException {
        int nParts = 10;
        long partSize = writeContext.getFileSize() / (long)nParts;
        StreamContext streamContext = writeContext.getStreamProvider(partSize);
        Path file = this.path.resolve(writeContext.getFileName());
        byte[] buffer = new byte[(int)writeContext.getFileSize()];
        AtomicLong totalContentRead = new AtomicLong();
        CountDownLatch latch = new CountDownLatch(streamContext.getNumberOfParts());
        int partIdx = 0;
        while (partIdx < streamContext.getNumberOfParts()) {
            int finalPartIdx = partIdx++;
            Thread thread = new Thread(() -> {
                try {
                    InputStreamContainer inputStreamContainer = streamContext.provideStream(finalPartIdx);
                    InputStream inputStream = inputStreamContainer.getInputStream();
                    long remainingContentLength = inputStreamContainer.getContentLength();
                    long offset = partSize * (long)finalPartIdx;
                    while (remainingContentLength > 0L) {
                        int readContentLength = inputStream.read(buffer, (int)offset, (int)remainingContentLength);
                        totalContentRead.addAndGet(readContentLength);
                        remainingContentLength -= (long)readContentLength;
                        offset += (long)readContentLength;
                    }
                    inputStream.close();
                }
                catch (IOException e) {
                    completionListener.onFailure((Exception)e);
                }
                finally {
                    latch.countDown();
                }
            });
            thread.start();
        }
        try {
            if (!latch.await(30000L, TimeUnit.MILLISECONDS)) {
                throw new IOException("Timed out waiting for file transfer to complete for " + writeContext.getFileName());
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Await interrupted on CountDownLatch, transfer failed for " + writeContext.getFileName());
        }
        try (OutputStream outputStream = Files.newOutputStream(file, StandardOpenOption.CREATE_NEW);){
            outputStream.write(buffer);
        }
        if (writeContext.getFileSize() != totalContentRead.get()) {
            throw new IOException("Incorrect content length read for file " + writeContext.getFileName() + ", actual file size: " + writeContext.getFileSize() + ", bytes read: " + totalContentRead.get());
        }
        try {
            if (this.isSegmentFile(writeContext.getFileName()) && this.triggerDataIntegrityFailure) {
                completionListener.onFailure((Exception)new RuntimeException((Throwable)new CorruptIndexException("Data integrity check failure for file: " + writeContext.getFileName(), writeContext.getFileName())));
            } else {
                writeContext.getUploadFinalizer().accept((Object)true);
                completionListener.onResponse(null);
            }
        }
        catch (Exception e) {
            completionListener.onFailure(e);
        }
    }

    public void readBlobAsync(String blobName, ActionListener<ReadContext> listener) {
        new Thread(() -> {
            try {
                long contentLength = ((BlobMetadata)this.listBlobs().get(blobName)).length();
                long partSize = contentLength / 10L;
                int numberOfParts = (int)(contentLength % partSize == 0L ? contentLength / partSize : contentLength / partSize + 1L);
                ArrayList<ReadContext.StreamPartCreator> blobPartStreams = new ArrayList<ReadContext.StreamPartCreator>();
                for (int partNumber = 0; partNumber < numberOfParts; ++partNumber) {
                    long offset = (long)partNumber * partSize;
                    InputStreamContainer blobPartStream = new InputStreamContainer(this.readBlob(blobName, offset, partSize), partSize, offset);
                    blobPartStreams.add(() -> CompletableFuture.completedFuture(blobPartStream));
                }
                ReadContext blobReadContext = new ReadContext.Builder(contentLength, blobPartStreams).build();
                listener.onResponse((Object)blobReadContext);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }).start();
    }

    public boolean remoteIntegrityCheckSupported() {
        return true;
    }

    private boolean isSegmentFile(String filename) {
        return !filename.endsWith(".tlog") && !filename.endsWith(".ckp");
    }

    public void deleteAsync(ActionListener<DeleteResult> completionListener) {
        throw new UnsupportedOperationException("deleteAsync");
    }

    public void deleteBlobsAsyncIgnoringIfNotExists(List<String> blobNames, ActionListener<Void> completionListener) {
        throw new UnsupportedOperationException("deleteBlobsAsyncIgnoringIfNotExists");
    }
}

