/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.util.Objects;
import org.apache.lucene.util.BytesRef;

public final class DocIdSeqNoAndSource {
    private final String id;
    private final BytesRef source;
    private final long seqNo;
    private final long primaryTerm;
    private final long version;

    public DocIdSeqNoAndSource(String id, BytesRef source, long seqNo, long primaryTerm, long version) {
        this.id = id;
        this.source = source;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public BytesRef getSource() {
        return this.source;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocIdSeqNoAndSource that = (DocIdSeqNoAndSource)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && this.seqNo == that.seqNo && this.primaryTerm == that.primaryTerm && this.version == that.version;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source, this.seqNo, this.primaryTerm, this.version);
    }

    public String toString() {
        return "doc{id='" + this.id + " seqNo=" + this.seqNo + " primaryTerm=" + this.primaryTerm + " version=" + this.version + " source= " + (this.source != null ? this.source.utf8ToString() : null) + "}";
    }
}

