/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardRoutingState;
import org.opensearch.cluster.routing.UnassignedInfo;

public class ShardRoutingHelper {
    public static ShardRouting relocate(ShardRouting routing, String nodeId) {
        return ShardRoutingHelper.relocate(routing, nodeId, -1L);
    }

    public static ShardRouting relocate(ShardRouting routing, String nodeId, long expectedByteSize) {
        return routing.relocate(nodeId, expectedByteSize);
    }

    public static ShardRouting moveToStarted(ShardRouting routing) {
        return routing.moveToStarted();
    }

    public static ShardRouting initialize(ShardRouting routing, String nodeId) {
        return ShardRoutingHelper.initialize(routing, nodeId, -1L);
    }

    public static ShardRouting initialize(ShardRouting routing, String nodeId, long expectedSize) {
        return routing.initialize(nodeId, null, expectedSize);
    }

    public static ShardRouting initWithSameId(ShardRouting copy, RecoverySource recoverySource) {
        return new ShardRouting(copy.shardId(), copy.currentNodeId(), copy.relocatingNodeId(), copy.primary(), ShardRoutingState.INITIALIZING, recoverySource, new UnassignedInfo(UnassignedInfo.Reason.REINITIALIZED, null), copy.allocationId(), copy.getExpectedShardSize());
    }

    public static ShardRouting moveToUnassigned(ShardRouting routing, UnassignedInfo info) {
        return routing.moveToUnassigned(info);
    }

    public static ShardRouting newWithRestoreSource(ShardRouting routing, RecoverySource recoverySource) {
        return new ShardRouting(routing.shardId(), routing.currentNodeId(), routing.relocatingNodeId(), routing.primary(), routing.state(), recoverySource, routing.unassignedInfo(), routing.allocationId(), routing.getExpectedShardSize());
    }
}

