/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.nio;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.opensearch.nio.ChannelContext;
import org.opensearch.nio.EventHandler;
import org.opensearch.nio.NioSelector;
import org.opensearch.nio.ServerChannelContext;
import org.opensearch.nio.SocketChannelContext;
import org.opensearch.transport.nio.MockNioTransport;

public class TestEventHandler
extends EventHandler {
    private final Set<SocketChannelContext> hasConnectedMap = Collections.newSetFromMap(new WeakHashMap());
    private final Set<SocketChannelContext> hasConnectExceptionMap = Collections.newSetFromMap(new WeakHashMap());
    private final MockNioTransport.TransportThreadWatchdog transportThreadWatchdog;

    TestEventHandler(Consumer<Exception> exceptionHandler, Supplier<NioSelector> selectorSupplier, MockNioTransport.TransportThreadWatchdog transportThreadWatchdog) {
        super(exceptionHandler, selectorSupplier);
        this.transportThreadWatchdog = transportThreadWatchdog;
    }

    protected void acceptChannel(ServerChannelContext context) throws IOException {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.acceptChannel(context);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acceptException(ServerChannelContext context, Exception exception) {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.acceptException(context, exception);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    protected void handleRegistration(ChannelContext<?> context) throws IOException {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.handleRegistration(context);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registrationException(ChannelContext<?> context, Exception exception) {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.registrationException(context, exception);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    protected void handleActive(ChannelContext<?> context) throws IOException {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.handleActive(context);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activeException(ChannelContext<?> context, Exception exception) {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.activeException(context, exception);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    public void handleConnect(SocketChannelContext context) throws IOException {
        assert (!this.hasConnectedMap.contains(context)) : "handleConnect should only be called is a channel is not yet connected";
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.handleConnect(context);
            if (context.isConnectComplete()) {
                this.hasConnectedMap.add(context);
            }
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectException(SocketChannelContext context, Exception e) {
        assert (!this.hasConnectExceptionMap.contains(context)) : "connectException should only called at maximum once per channel";
        boolean registered = this.transportThreadWatchdog.register();
        this.hasConnectExceptionMap.add(context);
        try {
            super.connectException(context, e);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    protected void handleRead(SocketChannelContext context) throws IOException {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.handleRead(context);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readException(SocketChannelContext context, Exception exception) {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.readException(context, exception);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    protected void handleWrite(SocketChannelContext context) throws IOException {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.handleWrite(context);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeException(SocketChannelContext context, Exception exception) {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.writeException(context, exception);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    protected void handleTask(Runnable task) {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.handleTask(task);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    protected void taskException(Exception exception) {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.taskException(exception);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    protected void handleClose(ChannelContext<?> context) throws IOException {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.handleClose(context);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeException(ChannelContext<?> context, Exception exception) {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.closeException(context, exception);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void genericChannelException(ChannelContext<?> context, Exception exception) {
        boolean registered = this.transportThreadWatchdog.register();
        try {
            super.genericChannelException(context, exception);
        }
        finally {
            if (registered) {
                this.transportThreadWatchdog.unregister();
            }
        }
    }
}

