/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.test.transport.MockTransport;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;

public class CapturingTransport
extends MockTransport
implements Transport {
    private BlockingQueue<CapturedRequest> capturedRequests = ConcurrentCollections.newBlockingQueue();

    public CapturedRequest[] capturedRequests() {
        return this.capturedRequests.toArray(new CapturedRequest[0]);
    }

    public CapturedRequest[] getCapturedRequestsAndClear() {
        ArrayList requests = new ArrayList(this.capturedRequests.size());
        this.capturedRequests.drainTo(requests);
        return requests.toArray(new CapturedRequest[0]);
    }

    private Map<String, List<CapturedRequest>> groupRequestsByTargetNode(Collection<CapturedRequest> requests) {
        HashMap<String, List<CapturedRequest>> result = new HashMap<String, List<CapturedRequest>>();
        for (CapturedRequest request : requests) {
            result.computeIfAbsent(request.node.getId(), node -> new ArrayList()).add(request);
        }
        return result;
    }

    public Map<String, List<CapturedRequest>> capturedRequestsByTargetNode() {
        return this.groupRequestsByTargetNode(this.capturedRequests);
    }

    public Map<String, List<CapturedRequest>> getCapturedRequestsByTargetNodeAndClear() {
        ArrayList<CapturedRequest> requests = new ArrayList<CapturedRequest>(this.capturedRequests.size());
        this.capturedRequests.drainTo(requests);
        return this.groupRequestsByTargetNode(requests);
    }

    public void clear() {
        this.capturedRequests.clear();
    }

    @Override
    protected void onSendRequest(long requestId, String action, TransportRequest request, DiscoveryNode node) {
        this.capturedRequests.add(new CapturedRequest(node, requestId, action, request, null));
    }

    @Override
    protected void onSendRequest(long requestId, String action, TransportRequest request, DiscoveryNode node, TransportRequestOptions options) {
        this.capturedRequests.add(new CapturedRequest(node, requestId, action, request, options));
    }

    public static class CapturedRequest {
        public final DiscoveryNode node;
        public final long requestId;
        public final String action;
        public final TransportRequest request;
        public final TransportRequestOptions options;

        CapturedRequest(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) {
            this.node = node;
            this.requestId = requestId;
            this.action = action;
            this.request = request;
            this.options = options;
        }
    }
}

