/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.tasks;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskAwareRequest;
import org.opensearch.tasks.TaskManager;
import org.opensearch.test.tasks.MockTaskManagerListener;
import org.opensearch.threadpool.ThreadPool;

public class MockTaskManager
extends TaskManager {
    private static final Logger logger = LogManager.getLogger(MockTaskManager.class);
    public static final Setting<Boolean> USE_MOCK_TASK_MANAGER_SETTING = Setting.boolSetting((String)"tests.mock.taskmanager.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Collection<MockTaskManagerListener> listeners = new CopyOnWriteArrayList<MockTaskManagerListener>();

    public MockTaskManager(Settings settings, ThreadPool threadPool, Set<String> taskHeaders) {
        super(settings, threadPool, taskHeaders);
    }

    public Task register(String type, String action, TaskAwareRequest request) {
        Task task = super.register(type, action, request);
        for (MockTaskManagerListener listener : this.listeners) {
            try {
                listener.onTaskRegistered(task);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to notify task manager listener about registering the task with id {}", (Object)task.getId()), (Throwable)e);
            }
        }
        return task;
    }

    public Task unregister(Task task) {
        Task removedTask = super.unregister(task);
        if (removedTask != null) {
            for (MockTaskManagerListener listener : this.listeners) {
                try {
                    listener.onTaskUnregistered(task);
                }
                catch (Exception e) {
                    logger.warn(() -> new ParameterizedMessage("failed to notify task manager listener about unregistering the task with id {}", (Object)task.getId()), (Throwable)e);
                }
            }
        } else {
            logger.warn("trying to remove the same with id {} twice", (Object)task.getId());
        }
        return removedTask;
    }

    public void waitForTaskCompletion(Task task, long untilInNanos) {
        for (MockTaskManagerListener listener : this.listeners) {
            try {
                listener.waitForTaskCompletion(task);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to notify task manager listener about waitForTaskCompletion the task with id {}", (Object)task.getId()), (Throwable)e);
            }
        }
        super.waitForTaskCompletion(task, untilInNanos);
    }

    public ThreadContext.StoredContext taskExecutionStarted(Task task) {
        for (MockTaskManagerListener listener : this.listeners) {
            listener.taskExecutionStarted(task, false);
        }
        ThreadContext.StoredContext storedContext = super.taskExecutionStarted(task);
        return () -> {
            for (MockTaskManagerListener listener : this.listeners) {
                listener.taskExecutionStarted(task, true);
            }
            storedContext.restore();
        };
    }

    public void addListener(MockTaskManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MockTaskManagerListener listener) {
        this.listeners.remove(listener);
    }
}

