/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.test.rest.yaml.section.DoSection;
import org.opensearch.test.rest.yaml.section.ExecutableSection;
import org.opensearch.test.rest.yaml.section.ParserUtils;
import org.opensearch.test.rest.yaml.section.SetSection;
import org.opensearch.test.rest.yaml.section.SkipSection;

public class SetupSection {
    public static final SetupSection EMPTY = new SetupSection(SkipSection.EMPTY, Collections.emptyList());
    private final SkipSection skipSection;
    private final List<ExecutableSection> executableSections;

    static SetupSection parseIfNext(XContentParser parser) throws IOException {
        ParserUtils.advanceToFieldName(parser);
        if ("setup".equals(parser.currentName())) {
            parser.nextToken();
            SetupSection section = SetupSection.parse(parser);
            parser.nextToken();
            return section;
        }
        return EMPTY;
    }

    public static SetupSection parse(XContentParser parser) throws IOException {
        SkipSection skipSection = SkipSection.parseIfNext(parser);
        ArrayList<ExecutableSection> executableSections = new ArrayList<ExecutableSection>();
        while (parser.currentToken() != XContentParser.Token.END_ARRAY) {
            ParserUtils.advanceToFieldName(parser);
            if ("do".equals(parser.currentName())) {
                executableSections.add(DoSection.parse(parser));
            } else if ("set".equals(parser.currentName())) {
                executableSections.add(SetSection.parse(parser));
            } else {
                throw new IllegalArgumentException("section [" + parser.currentName() + "] not supported within setup section");
            }
            parser.nextToken();
        }
        parser.nextToken();
        return new SetupSection(skipSection, executableSections);
    }

    public SetupSection(SkipSection skipSection, List<ExecutableSection> executableSections) {
        this.skipSection = Objects.requireNonNull(skipSection, "skip section cannot be null");
        this.executableSections = Collections.unmodifiableList(executableSections);
    }

    public SkipSection getSkipSection() {
        return this.skipSection;
    }

    public List<ExecutableSection> getExecutableSections() {
        return this.executableSections;
    }

    public boolean isEmpty() {
        return EMPTY.equals(this);
    }
}

