/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest.yaml.restspec;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.opensearch.common.io.PathUtils;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.test.rest.yaml.restspec.ClientYamlSuiteRestApi;
import org.opensearch.test.rest.yaml.restspec.ClientYamlSuiteRestApiParser;

public class ClientYamlSuiteRestSpec {
    private final Set<String> globalParameters = new HashSet<String>();
    private final Map<String, ClientYamlSuiteRestApi> restApiMap = new HashMap<String, ClientYamlSuiteRestApi>();

    ClientYamlSuiteRestSpec() {
    }

    private void addApi(ClientYamlSuiteRestApi restApi) {
        ClientYamlSuiteRestApi previous = this.restApiMap.putIfAbsent(restApi.getName(), restApi);
        if (previous != null) {
            throw new IllegalArgumentException("cannot register api [" + restApi.getName() + "] found in [" + restApi.getLocation() + "]. api with same name was already found in [" + previous.getLocation() + "]");
        }
    }

    public ClientYamlSuiteRestApi getApi(String api) {
        return this.restApiMap.get(api);
    }

    public Collection<ClientYamlSuiteRestApi> getApis() {
        return this.restApiMap.values();
    }

    public boolean isGlobalParameter(String param) {
        return this.globalParameters.contains(param);
    }

    public boolean isClientParameter(String name) {
        return "ignore".equals(name);
    }

    public static ClientYamlSuiteRestSpec load(String classpathPrefix) throws Exception {
        Path dir = PathUtils.get((URI)ClientYamlSuiteRestSpec.class.getResource(classpathPrefix).toURI());
        ClientYamlSuiteRestSpec restSpec = new ClientYamlSuiteRestSpec();
        ClientYamlSuiteRestApiParser restApiParser = new ClientYamlSuiteRestApiParser();
        try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
            stream.forEach(item -> {
                if (item.toString().endsWith(".json")) {
                    ClientYamlSuiteRestSpec.parseSpecFile(restApiParser, item, restSpec);
                }
            });
        }
        return restSpec;
    }

    private static void parseSpecFile(ClientYamlSuiteRestApiParser restApiParser, Path jsonFile, ClientYamlSuiteRestSpec restSpec) {
        try (InputStream stream = Files.newInputStream(jsonFile, new OpenOption[0]);
             XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, stream);){
            String filename = jsonFile.getFileName().toString();
            if (filename.equals("_common.json")) {
                ClientYamlSuiteRestSpec.parseCommonSpec(parser, restSpec);
            } else {
                ClientYamlSuiteRestApi restApi = restApiParser.parse(jsonFile.toString(), parser);
                String expectedApiName = filename.substring(0, filename.lastIndexOf(46));
                if (!restApi.getName().equals(expectedApiName)) {
                    throw new IllegalArgumentException("found api [" + restApi.getName() + "] in [" + jsonFile.toString() + "]. Each api is expected to have the same name as the file that defines it.");
                }
                restSpec.addApi(restApi);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Can't parse rest spec file: [" + String.valueOf(jsonFile) + "]", ex);
        }
    }

    static void parseCommonSpec(XContentParser parser, ClientYamlSuiteRestSpec restSpec) throws IOException {
        String currentFieldName = null;
        parser.nextToken();
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parser.currentToken() != XContentParser.Token.START_OBJECT) continue;
            if ("params".equals(currentFieldName)) {
                while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                    String param = parser.currentName();
                    if (restSpec.globalParameters.contains(param)) {
                        throw new IllegalArgumentException("Found duplicate global param [" + param + "]");
                    }
                    restSpec.globalParameters.add(param);
                    parser.nextToken();
                    if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                        throw new IllegalArgumentException("Expected params field in rest api definition to contain an object");
                    }
                    parser.skipChildren();
                }
                continue;
            }
            parser.skipChildren();
        }
    }
}

