/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.junit.After;
import org.junit.Before;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.indices.breaker.NoneCircuitBreakerService;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestRequest;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskListener;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.test.client.NoOpNodeClient;
import org.opensearch.test.rest.FakeRestChannel;
import org.opensearch.transport.client.node.NodeClient;
import org.opensearch.usage.UsageService;

public abstract class RestActionTestCase
extends OpenSearchTestCase {
    private RestController controller;
    protected VerifyingClient verifyingClient;

    @Before
    public void setUpController() {
        this.verifyingClient = new VerifyingClient(this.getTestName());
        this.controller = new RestController(Collections.emptySet(), null, (NodeClient)this.verifyingClient, (CircuitBreakerService)new NoneCircuitBreakerService(), new UsageService());
    }

    @After
    public void tearDownController() {
        this.verifyingClient.close();
    }

    protected RestController controller() {
        return this.controller;
    }

    protected void dispatchRequest(RestRequest request) {
        FakeRestChannel channel = new FakeRestChannel(request, false, 1);
        ThreadContext threadContext = new ThreadContext(Settings.EMPTY);
        this.controller.dispatchRequest(request, (RestChannel)channel, threadContext);
    }

    public static class VerifyingClient
    extends NoOpNodeClient {
        AtomicReference<BiFunction> executeVerifier = new AtomicReference();
        AtomicReference<BiFunction> executeLocallyVerifier = new AtomicReference();

        public VerifyingClient(String testName) {
            super(testName);
            this.reset();
        }

        public void reset() {
            this.executeVerifier.set((arg1, arg2) -> {
                throw new AssertionError();
            });
            this.executeLocallyVerifier.set((arg1, arg2) -> {
                throw new AssertionError();
            });
        }

        public <Request extends ActionRequest, Response extends ActionResponse> void setExecuteVerifier(BiFunction<ActionType<Response>, Request, Response> verifier) {
            this.executeVerifier.set(verifier);
        }

        @Override
        public <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
            listener.onResponse((Object)((ActionResponse)this.executeVerifier.get().apply(action, request)));
        }

        public <Request extends ActionRequest, Response extends ActionResponse> void setExecuteLocallyVerifier(BiFunction<ActionType<Response>, Request, Response> verifier) {
            this.executeLocallyVerifier.set(verifier);
        }

        @Override
        public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, ActionListener<Response> listener) {
            listener.onResponse((Object)((ActionResponse)this.executeLocallyVerifier.get().apply(action, request)));
            return null;
        }

        @Override
        public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, TaskListener<Response> listener) {
            listener.onResponse(null, (Object)((ActionResponse)this.executeLocallyVerifier.get().apply(action, request)));
            return null;
        }
    }
}

