/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.disruption;

import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.test.InternalTestCluster;
import org.opensearch.test.disruption.ServiceDisruptionScheme;

public abstract class SingleNodeDisruption
implements ServiceDisruptionScheme {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected volatile String disruptedNode;
    protected volatile InternalTestCluster cluster;
    protected final Random random;

    public SingleNodeDisruption(Random random) {
        this.random = new Random(random.nextLong());
    }

    @Override
    public void applyToCluster(InternalTestCluster cluster) {
        this.cluster = cluster;
        if (this.disruptedNode == null) {
            String[] nodes = cluster.getNodeNames();
            this.disruptedNode = nodes[this.random.nextInt(nodes.length)];
        }
    }

    @Override
    public void removeFromCluster(InternalTestCluster cluster) {
        if (this.disruptedNode != null) {
            this.removeFromNode(this.disruptedNode, cluster);
        }
    }

    @Override
    public synchronized void applyToNode(String node, InternalTestCluster cluster) {
    }

    @Override
    public synchronized void removeFromNode(String node, InternalTestCluster cluster) {
        if (this.disruptedNode == null) {
            return;
        }
        if (!node.equals(this.disruptedNode)) {
            return;
        }
        this.stopDisrupting();
        this.disruptedNode = null;
    }

    @Override
    public synchronized void testClusterClosed() {
        this.disruptedNode = null;
    }

    protected void ensureNodeCount(InternalTestCluster cluster) {
        Assert.assertFalse((String)"cluster failed to form after disruption was healed", (boolean)((ClusterHealthResponse)cluster.client().admin().cluster().prepareHealth(new String[0]).setWaitForNodes(String.valueOf(cluster.size())).setWaitForNoRelocatingShards(true).get()).isTimedOut());
    }
}

